/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.models;

import com.dataiku.scoring.Try;
import com.dataiku.scoring.linalg.Vector;
import com.dataiku.scoring.models.DecisionTreeRegressor;
import com.dataiku.scoring.models.Regressor;

public class ForestRegressor
implements Regressor {
    private static final long serialVersionUID = 0L;
    private final DecisionTreeRegressor[] trees;
    private final int size;

    public ForestRegressor(DecisionTreeRegressor[] trees) {
        this.trees = trees;
        this.size = trees.length;
    }

    public DecisionTreeRegressor[] getTrees() {
        return this.trees;
    }

    @Override
    public Try<Double> predict(Vector v) {
        double p = 0.0;
        for (int i = 0; i < this.size; ++i) {
            p += this.trees[i].predictUnsafe(v);
        }
        return Try.success(p / (double)this.size);
    }

    @Override
    public boolean expectsProcessedFeaturesAsDoubles() {
        return this.trees[0].expectsProcessedFeaturesAsDoubles();
    }
}

