/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.beanutils;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.hadoop.shaded.org.apache.commons.beanutils.PropertyUtils;
import org.apache.hadoop.shaded.org.apache.commons.collections.comparators.ComparableComparator;

public class BeanComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String property;
    private final Comparator<?> comparator;

    public BeanComparator() {
        this(null);
    }

    public BeanComparator(String property) {
        this(property, ComparableComparator.getInstance());
    }

    public BeanComparator(String property, Comparator<?> comparator) {
        this.setProperty(property);
        this.comparator = comparator != null ? comparator : ComparableComparator.getInstance();
    }

    @Override
    public int compare(T o1, T o2) {
        if (this.property == null) {
            return this.internalCompare(o1, o2);
        }
        try {
            Object value1 = PropertyUtils.getProperty(o1, this.property);
            Object value2 = PropertyUtils.getProperty(o2, this.property);
            return this.internalCompare(value1, value2);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanComparator)) {
            return false;
        }
        BeanComparator beanComparator = (BeanComparator)o;
        if (!this.comparator.equals(beanComparator.comparator)) {
            return false;
        }
        if (this.property == null) {
            return beanComparator.property == null;
        }
        return this.property.equals(beanComparator.property);
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public String getProperty() {
        return this.property;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    private int internalCompare(Object val1, Object val2) {
        Comparator<?> c = this.comparator;
        return c.compare(val1, val2);
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

