/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.utils;

import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class SessionLocalObject<T> {
    private static Logger logger = Logger.getLogger(SessionLocalObject.class);
    private HashMap<String, T> objs = new HashMap();
    private Callable<T> builder;
    private String name;
    static InheritableThreadLocal<String> itl = new InheritableThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "DEFAULT_SESSION_IDENTIFIER";
        }
    };

    SessionLocalObject(Callable<T> builder, String name) {
        this.builder = builder;
        this.name = name;
    }

    public static synchronized void enterSession(String sessionId) {
        itl.set(sessionId);
        logger.info((Object)("Attaching session [session=" + sessionId + "] to thread " + Thread.currentThread().getName() + " [id=" + Thread.currentThread().getId() + "]"));
    }

    public synchronized void removeFromSession() {
        this.objs.remove(this.get());
        logger.info((Object)("Removing SLO [name=" + this.name + "] from session [session=" + this.currentSession() + "]"));
    }

    public synchronized String currentSession() {
        return (String)itl.get();
    }

    public synchronized T get() {
        String sessionId = this.currentSession();
        logger.info((Object)("Use SLO [name=" + this.name + "] [session=" + sessionId + "]"));
        T o = this.objs.get(sessionId);
        if (o == null) {
            try {
                o = this.builder.call();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            this.objs.put(sessionId, o);
        }
        return o;
    }
}

