/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.fs;

import com.dataiku.dip.fs.FilesSelectionRule;
import com.dataiku.dip.utils.PathUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FilesSelectionRules {
    public Mode mode = Mode.ALL;
    public List<FilesSelectionRule> excludeRules = new ArrayList<FilesSelectionRule>();
    public List<FilesSelectionRule> includeRules = new ArrayList<FilesSelectionRule>();
    public List<String> explicitFiles = new ArrayList<String>();
    private static Logger logger = Logger.getLogger((String)"dku.fsproviders.rules");

    public boolean excludesPrefix(String dirPath) {
        assert (!dirPath.startsWith("/"));
        switch (this.mode) {
            case ALL: {
                return false;
            }
            case EXPLICIT_SELECT_FILES: {
                return false;
            }
            case RULES_ALL_BUT_EXCLUDED: {
                return this.excludesUsineExcludedRules(dirPath);
            }
            case RULES_INCLUDED_ONLY: {
                return this.excludesUsingIncludedRules(dirPath);
            }
        }
        throw new Error("unreachable");
    }

    private boolean excludesUsingIncludedRules(String dirPath) {
        if (this.includeRules.isEmpty()) {
            return true;
        }
        for (FilesSelectionRule rule : this.includeRules) {
            if (rule.matchesPartly(dirPath) == FilesSelectionRule.PartialMatchResult.WONT_MATCH) continue;
            return false;
        }
        return true;
    }

    private boolean excludesUsineExcludedRules(String dirPath) {
        for (FilesSelectionRule rule : this.excludeRules) {
            if (rule.matchesPartly(dirPath) != FilesSelectionRule.PartialMatchResult.WILL_MATCH_ALL) continue;
            return true;
        }
        return false;
    }

    public boolean includes(String path) {
        if (path.startsWith("/") || path.contains("//")) {
            return false;
        }
        switch (this.mode) {
            case ALL: {
                return true;
            }
            case EXPLICIT_SELECT_FILES: {
                return this.includesUsingFiles(path);
            }
            case RULES_ALL_BUT_EXCLUDED: {
                return this.includesUsingExcludedRules(path);
            }
            case RULES_INCLUDED_ONLY: {
                return this.includesUsingIncludedRules(path);
            }
        }
        throw new Error("unreachable");
    }

    private boolean includesUsingIncludedRules(String path) {
        for (FilesSelectionRule rule : this.includeRules) {
            if (!rule.matches(path)) continue;
            return true;
        }
        return false;
    }

    private boolean includesUsingExcludedRules(String path) {
        for (FilesSelectionRule rule : this.excludeRules) {
            if (!rule.matches(path)) continue;
            return false;
        }
        return true;
    }

    private boolean includesUsingFiles(String path) {
        for (String explicitPath : this.explicitFiles) {
            String cleanExplicitPath = PathUtils.slashes((String)explicitPath, (Boolean)false, (Boolean)false, (boolean)true, null);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Evaluate include of " + path + " against " + cleanExplicitPath));
            }
            if (cleanExplicitPath == null || !cleanExplicitPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    public static enum Mode {
        ALL,
        EXPLICIT_SELECT_FILES,
        RULES_ALL_BUT_EXCLUDED,
        RULES_INCLUDED_ONLY;

    }
}

