/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClientProvider;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.HttpClientOptions;
import com.dataiku.dss.shadelibazure.okhttp3.ConnectionPool;
import java.util.concurrent.TimeUnit;

public final class OkHttpAsyncClientProvider
implements HttpClientProvider {
    private static final boolean AZURE_ENABLE_HTTP_CLIENT_SHARING = Configuration.getGlobalConfiguration().get("AZURE_ENABLE_HTTP_CLIENT_SHARING", Boolean.FALSE);
    private final boolean enableHttpClientSharing;

    public OkHttpAsyncClientProvider() {
        this.enableHttpClientSharing = AZURE_ENABLE_HTTP_CLIENT_SHARING;
    }

    OkHttpAsyncClientProvider(Configuration configuration) {
        this.enableHttpClientSharing = configuration.get("AZURE_ENABLE_HTTP_CLIENT_SHARING", Boolean.FALSE);
    }

    @Override
    public HttpClient createInstance() {
        if (this.enableHttpClientSharing) {
            return GlobalOkHttpClient.HTTP_CLIENT.getHttpClient();
        }
        return new OkHttpAsyncHttpClientBuilder().build();
    }

    @Override
    public HttpClient createInstance(HttpClientOptions clientOptions) {
        if (clientOptions == null) {
            return this.createInstance();
        }
        OkHttpAsyncHttpClientBuilder builder = new OkHttpAsyncHttpClientBuilder();
        builder = builder.proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).connectionTimeout(clientOptions.getConnectTimeout()).writeTimeout(clientOptions.getWriteTimeout()).readTimeout(clientOptions.getReadTimeout());
        Integer poolSize = clientOptions.getMaximumConnectionPoolSize();
        int maximumConnectionPoolSize = poolSize != null && poolSize > 0 ? poolSize : 5;
        ConnectionPool connectionPool = new ConnectionPool(maximumConnectionPoolSize, clientOptions.getConnectionIdleTimeout().toMillis(), TimeUnit.MILLISECONDS);
        builder = builder.connectionPool(connectionPool);
        return builder.build();
    }

    private static enum GlobalOkHttpClient {
        HTTP_CLIENT(new OkHttpAsyncHttpClientBuilder().build());

        private final HttpClient httpClient;

        private GlobalOkHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        private HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

