/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.ProgressReporter;
import com.dataiku.dss.shadelibazure.okhttp3.MediaType;
import com.dataiku.dss.shadelibazure.okhttp3.RequestBody;
import com.dataiku.dss.shadelibazure.okio.Buffer;
import com.dataiku.dss.shadelibazure.okio.BufferedSink;
import com.dataiku.dss.shadelibazure.okio.ForwardingSink;
import com.dataiku.dss.shadelibazure.okio.Okio;
import com.dataiku.dss.shadelibazure.okio.Sink;
import java.io.IOException;
import java.util.Objects;

public final class OkHttpProgressReportingRequestBody
extends RequestBody {
    private final RequestBody delegate;
    private final ProgressReporter progressReporter;

    public OkHttpProgressReportingRequestBody(RequestBody delegate, ProgressReporter progressReporter) {
        this.delegate = Objects.requireNonNull(delegate, "'delegate' must not be null");
        this.progressReporter = Objects.requireNonNull(progressReporter, "'progressReporter' must not be null");
    }

    @Override
    public MediaType contentType() {
        return this.delegate.contentType();
    }

    @Override
    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    @Override
    public boolean isOneShot() {
        return this.delegate.isOneShot();
    }

    @Override
    public boolean isDuplex() {
        return this.delegate.isDuplex();
    }

    @Override
    public void writeTo(BufferedSink sink2) throws IOException {
        CountingSink countingSink = new CountingSink(sink2, this.progressReporter);
        BufferedSink bufferedSink = Okio.buffer(countingSink);
        this.delegate.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    private static final class CountingSink
    extends ForwardingSink {
        private final ProgressReporter progressReporter;

        CountingSink(Sink delegate, ProgressReporter progressReporter) {
            super(delegate);
            this.progressReporter = progressReporter;
        }

        @Override
        public void write(Buffer source2, long byteCount) throws IOException {
            super.write(source2, byteCount);
            this.progressReporter.reportProgress(byteCount);
        }
    }
}

