/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;

public enum HttpLogDetailLevel {
    NONE,
    BASIC,
    HEADERS,
    BODY,
    BODY_AND_HEADERS;

    static final String BASIC_VALUE = "basic";
    static final String HEADERS_VALUE = "headers";
    static final String BODY_VALUE = "body";
    static final String BODY_AND_HEADERS_VALUE = "body_and_headers";
    static final String BODYANDHEADERS_VALUE = "bodyandheaders";
    static final HttpLogDetailLevel ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL;

    static HttpLogDetailLevel fromConfiguration(Configuration configuration) {
        String detailLevel = configuration.get("AZURE_HTTP_LOG_DETAIL_LEVEL", "none");
        HttpLogDetailLevel logDetailLevel = BASIC_VALUE.equalsIgnoreCase(detailLevel) ? BASIC : (HEADERS_VALUE.equalsIgnoreCase(detailLevel) ? HEADERS : (BODY_VALUE.equalsIgnoreCase(detailLevel) ? BODY : (BODY_AND_HEADERS_VALUE.equalsIgnoreCase(detailLevel) || BODYANDHEADERS_VALUE.equalsIgnoreCase(detailLevel) ? BODY_AND_HEADERS : NONE)));
        return logDetailLevel;
    }

    public boolean shouldLogUrl() {
        return this != NONE;
    }

    public boolean shouldLogHeaders() {
        return this == HEADERS || this == BODY_AND_HEADERS;
    }

    public boolean shouldLogBody() {
        return this == BODY || this == BODY_AND_HEADERS;
    }

    static {
        ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL = HttpLogDetailLevel.fromConfiguration(Configuration.getGlobalConfiguration());
    }
}

