/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.UrlBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.net.MalformedURLException;

public class PortPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(PortPolicy.class);
    private final int port;
    private final boolean overwrite;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext context) {
            UrlBuilder urlBuilder = UrlBuilder.parse(context.getHttpRequest().getUrl());
            if (PortPolicy.this.overwrite || urlBuilder.getPort() == null) {
                LOGGER.atVerbose().addKeyValue("port", PortPolicy.this.port).log("Changing host");
                try {
                    context.getHttpRequest().setUrl(urlBuilder.setPort(PortPolicy.this.port).toUrl());
                }
                catch (MalformedURLException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException("Failed to set the HTTP request port to " + PortPolicy.this.port + ".", e));
                }
            }
        }
    };

    public PortPolicy(int port, boolean overwrite) {
        this.port = port;
        this.overwrite = overwrite;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.inner.process(context, next);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        return this.inner.processSync(context, next);
    }
}

