/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.rest;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RequestOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest.AsyncRestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest.RestProxyUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest.SwaggerMethodParser;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.rest.SyncRestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class RestProxy
implements InvocationHandler {
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLED = "com.dataiku.dss.shadelibazure.com.azure.core.http.restproxy.syncproxy.enable";
    private static final boolean GLOBAL_SYNC_PROXY_ENABLED = Configuration.getGlobalConfiguration().get("AZURE_HTTP_REST_PROXY_SYNC_PROXY_ENABLED", true);
    private final SwaggerInterfaceParser interfaceParser;
    private final AsyncRestProxy asyncRestProxy;
    private final HttpPipeline httpPipeline;
    private final SyncRestProxy syncRestProxy;

    private RestProxy(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        this.interfaceParser = interfaceParser;
        this.asyncRestProxy = new AsyncRestProxy(httpPipeline, serializer, interfaceParser);
        this.syncRestProxy = new SyncRestProxy(httpPipeline, serializer, interfaceParser);
        this.httpPipeline = httpPipeline;
    }

    private SwaggerMethodParser getMethodParser(Method method) {
        return this.interfaceParser.getMethodParser(method);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context contextData) {
        return this.httpPipeline.send(request, contextData);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) {
        SwaggerMethodParser methodParser = this.getMethodParser(method);
        RequestOptions options = methodParser.setRequestOptions(args2);
        Context context = methodParser.setContext(args2);
        if (methodParser.isReactive() || RestProxy.isSyncDisabled(context)) {
            return this.asyncRestProxy.invoke(proxy, method, options, options != null ? options.getErrorOptions() : null, options != null ? options.getRequestCallback() : null, methodParser, methodParser.isReactive(), args2);
        }
        return this.syncRestProxy.invoke(proxy, method, options, options != null ? options.getErrorOptions() : null, options != null ? options.getRequestCallback() : null, methodParser, false, args2);
    }

    private static boolean isSyncDisabled(Context context) {
        return (Boolean)context.getData(HTTP_REST_PROXY_SYNC_PROXY_ENABLED).orElse(GLOBAL_SYNC_PROXY_ENABLED) == false;
    }

    public static <A> A create(Class<A> swaggerInterface) {
        return RestProxy.create(swaggerInterface, RestProxyUtils.createDefaultPipeline(), RestProxyUtils.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline) {
        return RestProxy.create(swaggerInterface, httpPipeline, RestProxyUtils.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline, SerializerAdapter serializer) {
        SwaggerInterfaceParser interfaceParser = SwaggerInterfaceParser.getInstance(swaggerInterface);
        RestProxy restProxy = new RestProxy(httpPipeline, serializer, interfaceParser);
        return (A)Proxy.newProxyInstance(swaggerInterface.getClassLoader(), new Class[]{swaggerInterface}, (InvocationHandler)restProxy);
    }
}

