/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscriber;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoSink;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.util.concurrent.ExecutionException;

public final class AsynchronousByteChannelWriteSubscriber
implements Subscriber<ByteBuffer> {
    private static final ClientLogger LOGGER = new ClientLogger(AsynchronousByteChannelWriteSubscriber.class);
    private final AsynchronousByteChannel channel;
    private final MonoSink<Void> emitter;
    private Subscription subscription;
    private boolean done = false;

    public AsynchronousByteChannelWriteSubscriber(AsynchronousByteChannel channel, MonoSink<Void> emitter) {
        this.channel = channel;
        this.emitter = emitter;
    }

    @Override
    public void onSubscribe(Subscription s2) {
        if (Operators.validate(this.subscription, s2)) {
            this.subscription = s2;
            s2.request(1L);
        }
    }

    @Override
    public void onNext(ByteBuffer bytes) {
        if (this.done) {
            Operators.onNextDropped(bytes, Context.of(this.emitter.contextView()));
            return;
        }
        if (!bytes.hasRemaining()) {
            this.subscription.request(1L);
            return;
        }
        this.write(bytes);
        if (!this.done) {
            this.subscription.request(1L);
        }
    }

    private void write(ByteBuffer bytes) {
        try {
            while (bytes.hasRemaining()) {
                this.channel.write(bytes).get();
            }
        }
        catch (Exception ex) {
            if (ex instanceof ExecutionException) {
                this.onError(ex.getCause());
            }
            this.onError(ex);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.done) {
            Operators.onErrorDropped(throwable, Context.of(this.emitter.contextView()));
            return;
        }
        this.done = true;
        this.subscription.cancel();
        this.emitter.error(LOGGER.logThrowableAsError(throwable));
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.emitter.success();
    }
}

