/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ReflectiveInvoker;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.MethodHandle;

final class MethodHandleReflectiveInvoker
implements ReflectiveInvoker {
    private static final ClientLogger LOGGER = new ClientLogger(MethodHandleReflectiveInvoker.class);
    private static final Object[] NO_ARGS = new Object[0];
    private final MethodHandle methodHandle;

    MethodHandleReflectiveInvoker(MethodHandle methodHandle) {
        this.methodHandle = methodHandle;
    }

    @Override
    public Object invokeStatic(Object ... args2) throws Exception {
        try {
            return this.methodHandle.invokeWithArguments(args2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw LOGGER.logThrowableAsError((Error)throwable);
            }
            throw LOGGER.logThrowableAsError((Exception)throwable);
        }
    }

    @Override
    public Object invokeWithArguments(Object target, Object ... args2) throws Exception {
        try {
            return this.methodHandle.invokeWithArguments(MethodHandleReflectiveInvoker.createFinalArgs(target, args2));
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw LOGGER.logThrowableAsError((Error)throwable);
            }
            throw LOGGER.logThrowableAsError((Exception)throwable);
        }
    }

    @Override
    public int getParameterCount() {
        return this.methodHandle.type().parameterCount();
    }

    static Object[] createFinalArgs(Object target, Object ... args2) {
        if (target == null && (args2 == null || args2.length == 0)) {
            return NO_ARGS;
        }
        if (args2 == null || args2.length == 0) {
            return new Object[]{target};
        }
        Object[] finalArgs = new Object[args2.length + 1];
        finalArgs[0] = target;
        System.arraycopy(args2, 0, finalArgs, 1, args2.length);
        return finalArgs;
    }
}

