/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;

public final class AuthorizationChallengeParser {
    private AuthorizationChallengeParser() {
    }

    public static boolean isCaeClaimsChallenge(HttpResponse response) {
        String challenge = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        String parameters = AuthorizationChallengeParser.getChallengeParametersForScheme(challenge, "Bearer");
        String error = AuthorizationChallengeParser.getChallengeParameterValue(parameters, "error");
        String claims = AuthorizationChallengeParser.getChallengeParameterValue(parameters, "claims");
        return !CoreUtils.isNullOrEmpty(claims) && "insufficient_claims".equals(error);
    }

    public static String getChallengeParameterFromResponse(HttpResponse response, String challengeScheme, String parameter) {
        String challenge = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        String parameters = AuthorizationChallengeParser.getChallengeParametersForScheme(challenge, challengeScheme);
        return AuthorizationChallengeParser.getChallengeParameterValue(parameters, parameter);
    }

    private static String getChallengeParametersForScheme(String challenge, String challengeScheme) {
        int startIndex;
        if (CoreUtils.isNullOrEmpty(challenge)) {
            return null;
        }
        int schemeIndex = -1;
        int length = challenge.length();
        int schemeLength = challengeScheme.length();
        for (int i = 0; i <= length - schemeLength - 1; ++i) {
            if (!challenge.startsWith(challengeScheme, i) || i + schemeLength >= length || challenge.charAt(i + schemeLength) != ' ') continue;
            schemeIndex = i;
            break;
        }
        if (schemeIndex == -1) {
            return null;
        }
        int endIndex = challenge.length();
        for (startIndex = schemeIndex + challengeScheme.length(); startIndex < endIndex && Character.isWhitespace(challenge.charAt(startIndex)); ++startIndex) {
        }
        while (endIndex > startIndex && Character.isWhitespace(challenge.charAt(endIndex - 1))) {
            --endIndex;
        }
        return startIndex < endIndex ? challenge.substring(startIndex, endIndex) : null;
    }

    private static String getChallengeParameterValue(String parameters, String parameter) {
        String[] paramPairs;
        if (CoreUtils.isNullOrEmpty(parameters)) {
            return null;
        }
        for (String pair : paramPairs = parameters.split(",", -1)) {
            String key;
            int equalsIndex = pair.indexOf(61);
            if (equalsIndex == -1 || !(key = pair.substring(0, equalsIndex).trim()).equals(parameter)) continue;
            return pair.substring(equalsIndex + 1).replace("\"", "").trim();
        }
        return null;
    }
}

