/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling.Error;
import com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling.FinalResult;
import com.dataiku.dss.shadelibazure.com.azure.core.management.implementation.polling.PollingState;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerEncoding;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class PollOperation {
    private static final ClientLogger LOGGER = new ClientLogger(PollOperation.class);
    private static final LongRunningOperationStatus LRO_CANCELLED = LongRunningOperationStatus.fromString("Cancelled", true);

    public static <T> Function<PollingContext<PollResult<T>>, Mono<PollResponse<PollResult<T>>>> pollFunction(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type pollResultType, Context context) {
        return pollingContext -> {
            PollingState pollingState = PollingState.from(serializerAdapter, pollingContext);
            if (pollingState.getOperationStatus().isComplete()) {
                return Mono.defer(() -> Mono.just(PollOperation.pollResponseFromPollingState(serializerAdapter, pollResultType, pollingState)));
            }
            return PollOperation.doSinglePoll(pipeline, pollingState, context).flatMap(updatedState -> {
                updatedState.store(pollingContext);
                return Mono.defer(() -> Mono.just(PollOperation.pollResponseFromPollingState(serializerAdapter, pollResultType, updatedState)));
            });
        };
    }

    public static <T> BiFunction<PollingContext<PollResult<T>>, PollResponse<PollResult<T>>, Mono<PollResult<T>>> cancelFunction(Context context) {
        return (pollingContext, response) -> Mono.empty();
    }

    public static <T, U> Function<PollingContext<PollResult<T>>, Mono<U>> fetchResultFunction(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type finalResultType, Context context) {
        return pollingContext -> {
            PollingState pollingState = PollingState.from(serializerAdapter, pollingContext);
            FinalResult finalResult = pollingState.getFinalResult();
            if (finalResult == null) {
                return Mono.empty();
            }
            String value = finalResult.getResult();
            if (value != null) {
                Object result = PollOperation.deserialize(serializerAdapter, value, finalResultType);
                return result != null ? Mono.just(result) : Mono.empty();
            }
            return FluxUtil.fluxContext(fluxContext -> {
                fluxContext = CoreUtils.mergeContexts(fluxContext, context);
                return pipeline.send(PollOperation.decorateRequest(new HttpRequest(HttpMethod.GET, finalResult.getResultUri())), (Context)fluxContext).flux();
            }).next().flatMap(response -> response.getBodyAsString()).flatMap(body -> {
                Object result = PollOperation.deserialize(serializerAdapter, body, finalResultType);
                return result != null ? Mono.just(result) : Mono.empty();
            });
        };
    }

    private static Mono<PollingState> doSinglePoll(HttpPipeline pipeline, PollingState pollingState, Context context) {
        return FluxUtil.fluxContext(fluxContext -> {
            fluxContext = CoreUtils.mergeContexts(fluxContext, context);
            return pipeline.send(PollOperation.decorateRequest(new HttpRequest(HttpMethod.GET, pollingState.getPollUrl())), (Context)fluxContext).flux();
        }).next().flatMap(response -> response.getBodyAsString().map(body -> pollingState.update(response.getStatusCode(), response.getHeaders(), (String)body)).switchIfEmpty(Mono.fromSupplier(() -> pollingState.update(response.getStatusCode(), response.getHeaders(), null))));
    }

    static <T> PollResponse<PollResult<T>> pollResponseFromPollingState(SerializerAdapter serializerAdapter, Type pollResultType, PollingState pollingState) {
        if (pollingState.getOperationStatus().isComplete()) {
            if (pollingState.getOperationStatus() == LongRunningOperationStatus.FAILED || pollingState.getOperationStatus() == LRO_CANCELLED) {
                Error lroInitError = pollingState.getSynchronouslyFailedLroError();
                if (lroInitError != null) {
                    return PollOperation.errorPollResponse(pollingState.getOperationStatus(), lroInitError);
                }
                Error pollError = pollingState.getPollError();
                if (pollError != null) {
                    return PollOperation.errorPollResponse(pollingState.getOperationStatus(), pollError);
                }
                throw new IllegalStateException("Either LroError or PollError mustbe set when OperationStatus is in Failed|Cancelled State.");
            }
            return PollOperation.pollResponse(serializerAdapter, pollingState.getOperationStatus(), pollingState.getLastResponseBody(), pollResultType, pollingState.getPollDelay());
        }
        return PollOperation.pollResponse(serializerAdapter, pollingState.getOperationStatus(), pollingState.getLastResponseBody(), pollResultType, pollingState.getPollDelay());
    }

    static <T> PollResponse<PollResult<T>> pollResponse(SerializerAdapter serializerAdapter, LongRunningOperationStatus operationStatus, String pollResponseBody, Type pollResultType, Duration pollDelay) {
        Object result = PollOperation.deserialize(serializerAdapter, pollResponseBody, pollResultType);
        return new PollResponse<PollResult<T>>(operationStatus, new PollResult(result), pollDelay);
    }

    static <T> PollResponse<PollResult<T>> errorPollResponse(LongRunningOperationStatus operationStatus, Error error) {
        return new PollResponse(operationStatus, new PollResult(new PollResult.Error(error.getMessage(), error.getResponseStatusCode(), new HttpHeaders(error.getResponseHeaders()), error.getResponseBody())));
    }

    private static HttpRequest decorateRequest(HttpRequest httpRequest) {
        return httpRequest.setHeader(HttpHeaderName.ACCEPT, "application/json");
    }

    public static <U> U deserialize(SerializerAdapter serializerAdapter, String value, Type type) {
        if (CoreUtils.isNullOrEmpty(value)) {
            LOGGER.verbose("Ignoring decoding of null or empty value to:" + type);
            return null;
        }
        try {
            return (U)serializerAdapter.deserialize(value, type, SerializerEncoding.JSON);
        }
        catch (IOException | RuntimeException ioe) {
            LOGGER.logExceptionAsWarning(new IllegalArgumentException("Unable to decode '" + value + "' to: " + type, ioe));
            return null;
        }
    }
}

