/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.models;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.Option;
import com.dataiku.dss.shadelibazure.com.azure.core.models.JsonPatchOperationKind;
import com.dataiku.dss.shadelibazure.com.azure.core.models.JsonPatchOperationSerializer;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Objects;

@JsonSerialize(using=JsonPatchOperationSerializer.class)
final class JsonPatchOperation
implements JsonSerializable<JsonPatchOperation> {
    private final JsonPatchOperationKind op;
    private final String from;
    private final String path;
    private final Option<String> value;

    JsonPatchOperation(JsonPatchOperationKind op, String from, String path, Option<String> value) {
        this.op = op;
        this.from = from;
        this.path = path;
        this.value = value;
    }

    JsonPatchOperationKind getOp() {
        return this.op;
    }

    String getFrom() {
        return this.from;
    }

    String getPath() {
        return this.path;
    }

    Option<String> getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.op.toString(), this.from, this.path, this.value == null ? null : this.value.getValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonPatchOperation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JsonPatchOperation other = (JsonPatchOperation)obj;
        return Objects.equals((Object)this.op, (Object)other.op) && Objects.equals(this.from, other.from) && Objects.equals(this.path, other.path) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        return this.buildString(new StringBuilder()).toString();
    }

    StringBuilder buildString(StringBuilder builder) {
        builder.append("{\"op\":\"").append(this.op.toString()).append("\"");
        if (this.from != null) {
            builder.append(",\"from\":\"").append(this.from).append("\"");
        }
        builder.append(",\"path\":\"").append(this.path).append("\"");
        if (this.value.isInitialized()) {
            builder.append(",\"value\":").append(this.value.getValue());
        }
        return builder.append("}");
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("op", this.op.toString()).writeStringField("from", this.from).writeStringField("path", this.path);
        if (this.value.isInitialized()) {
            String valueString = this.value.getValue();
            if (valueString == null) {
                jsonWriter.writeNullField("value");
            } else {
                jsonWriter.writeRawField("value", this.value.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static JsonPatchOperation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonPatchOperationKind op = null;
            String from = null;
            String path = null;
            Option<String> value = Option.uninitialized();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("op".equals(fieldName)) {
                    op = JsonPatchOperationKind.fromString(reader.getString());
                    continue;
                }
                if ("from".equals(fieldName)) {
                    from = reader.getString();
                    continue;
                }
                if ("path".equals(fieldName)) {
                    path = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = Option.of(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new JsonPatchOperation(op, from, path, value);
        });
    }
}

