/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.ConfigurationProperty;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public final class ConfigurationPropertyBuilder<T> {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Function<String, String> PERMIT_VALUE_SANITIZER = value -> value;
    private static final Function<String, Boolean> CONFIGURATION_PROPERTY_BOOLEAN_CONVERTER = Boolean::valueOf;
    private static final Function<String, Duration> CONFIGURATION_PROPERTY_DURATION_CONVERTER = value -> {
        long timeoutMillis = Long.parseLong(value);
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("Duration can't be negative");
        }
        return Duration.ofMillis(timeoutMillis);
    };
    private static final Function<String, Integer> CONFIGURATION_PROPERTY_INTEGER_CONVERTER = Integer::valueOf;
    private static final Function<String, String> CONFIGURATION_PROPERTY_STRING_CONVERTER = Function.identity();
    private final String name;
    private final Function<String, T> converter;
    private String[] aliases = EMPTY_ARRAY;
    private String environmentVariableName;
    private String systemPropertyName;
    private T defaultValue;
    private boolean shared;
    private Function<String, String> valueSanitizer;
    private boolean required;

    public static ConfigurationPropertyBuilder<String> ofString(String name) {
        return new ConfigurationPropertyBuilder<String>(name, CONFIGURATION_PROPERTY_STRING_CONVERTER);
    }

    public static ConfigurationPropertyBuilder<Integer> ofInteger(String name) {
        return new ConfigurationPropertyBuilder<Integer>(name, CONFIGURATION_PROPERTY_INTEGER_CONVERTER).logValue(true);
    }

    public static ConfigurationPropertyBuilder<Duration> ofDuration(String name) {
        return new ConfigurationPropertyBuilder<Duration>(name, CONFIGURATION_PROPERTY_DURATION_CONVERTER).logValue(true);
    }

    public static ConfigurationPropertyBuilder<Boolean> ofBoolean(String name) {
        return new ConfigurationPropertyBuilder<Boolean>(name, CONFIGURATION_PROPERTY_BOOLEAN_CONVERTER).logValue(true);
    }

    public ConfigurationPropertyBuilder(String name, Function<String, T> converter) {
        this.name = Objects.requireNonNull(name, "'name' cannot be null");
        this.converter = Objects.requireNonNull(converter, "'converter' cannot be null");
    }

    public ConfigurationPropertyBuilder<T> defaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConfigurationPropertyBuilder<T> shared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public ConfigurationPropertyBuilder<T> logValue(boolean logValue) {
        if (logValue) {
            this.valueSanitizer = PERMIT_VALUE_SANITIZER;
        }
        return this;
    }

    public ConfigurationPropertyBuilder<T> required(boolean required) {
        this.required = required;
        return this;
    }

    public ConfigurationPropertyBuilder<T> aliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public ConfigurationPropertyBuilder<T> environmentVariableName(String environmentVariableName) {
        this.environmentVariableName = environmentVariableName;
        return this;
    }

    public ConfigurationPropertyBuilder<T> systemPropertyName(String systemPropertyName) {
        this.systemPropertyName = systemPropertyName;
        return this;
    }

    public ConfigurationProperty<T> build() {
        return new ConfigurationProperty<T>(this.name, this.defaultValue, this.required, this.converter, this.shared, this.environmentVariableName, this.systemPropertyName, this.aliases, this.valueSanitizer);
    }
}

