/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util;

import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ConfigurationProperty;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ConfigurationPropertyBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.util.metrics.MeterProvider;

public class MetricsOptions {
    private static final ConfigurationProperty<Boolean> IS_DISABLED_PROPERTY = ConfigurationPropertyBuilder.ofBoolean("metrics.disabled").environmentVariableName("AZURE_METRICS_DISABLED").shared(true).defaultValue(false).build();
    private static final ConfigurationProperty<String> PROVIDER_NAME_PROPERTY = ConfigurationPropertyBuilder.ofString("metrics.provider.implementation").environmentVariableName("AZURE_METRICS_IMPLEMENTATION").shared(true).build();
    private static final Configuration GLOBAL_CONFIG = Configuration.getGlobalConfiguration();
    private final Class<? extends MeterProvider> meterProvider;
    private boolean isEnabled;

    public MetricsOptions() {
        this(GLOBAL_CONFIG);
    }

    protected MetricsOptions(Class<? extends MeterProvider> meterProvider) {
        this.isEnabled = GLOBAL_CONFIG.get(IS_DISABLED_PROPERTY) == false;
        this.meterProvider = meterProvider;
    }

    private MetricsOptions(Configuration configuration) {
        this.isEnabled = configuration.get(IS_DISABLED_PROPERTY) == false;
        String className = configuration.get(PROVIDER_NAME_PROPERTY);
        this.meterProvider = className != null ? ImplUtils.getClassByName(className) : null;
    }

    public static MetricsOptions fromConfiguration(Configuration configuration) {
        if (configuration.contains(IS_DISABLED_PROPERTY)) {
            return new MetricsOptions().setEnabled(configuration.get(IS_DISABLED_PROPERTY) == false);
        }
        return new MetricsOptions();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public MetricsOptions setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        return this;
    }

    public Class<? extends MeterProvider> getMeterProvider() {
        return this.meterProvider;
    }
}

