/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PollingContext<T> {
    private static final ClientLogger LOGGER = new ClientLogger(PollingContext.class);
    private final Map<String, String> map;
    private volatile PollResponse<T> activationResponse;
    private volatile PollResponse<T> latestResponse;

    public String getData(String name) {
        return this.map.get(name);
    }

    public PollingContext<T> setData(String name, String value) {
        this.map.put(name, value);
        return this;
    }

    public PollResponse<T> getActivationResponse() {
        return this.activationResponse;
    }

    public PollResponse<T> getLatestResponse() {
        return this.latestResponse;
    }

    void setLatestResponse(PollResponse<T> latestResponse) {
        this.latestResponse = Objects.requireNonNull(latestResponse, "'latestResponse' is required.");
    }

    void setOnetimeActivationResponse(PollResponse<T> activationResponse) {
        if (this.activationResponse != null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("setOnetimeActivationResponse can be called only once."));
        }
        this.activationResponse = activationResponse;
        this.latestResponse = this.activationResponse;
    }

    PollingContext<T> copy() {
        return new PollingContext<T>(this.activationResponse, this.latestResponse, new HashMap<String, String>(this.map));
    }

    PollingContext() {
        this.map = new HashMap<String, String>();
    }

    private PollingContext(PollResponse<T> activationResponse, PollResponse<T> latestResponse, Map<String, String> map) {
        this.activationResponse = Objects.requireNonNull(activationResponse, "'activationResponse' cannot be null.");
        this.latestResponse = Objects.requireNonNull(latestResponse, "'latestResponse' cannot be null.");
        this.map = map;
    }
}

