/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.tracing;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.NoopTracer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.ProcessKind;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.SpanKind;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.StartSpanOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.TracingLink;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.Utils;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface Tracer {
    @Deprecated
    public static final String PARENT_SPAN_KEY = "parent-span";
    public static final String PARENT_TRACE_CONTEXT_KEY = "trace-context";
    @Deprecated
    public static final String USER_SPAN_NAME_KEY = "user-span-name";
    public static final String ENTITY_PATH_KEY = "entity-path";
    public static final String HOST_NAME_KEY = "hostname";
    public static final String SPAN_CONTEXT_KEY = "span-context";
    @Deprecated
    public static final String DIAGNOSTIC_ID_KEY = "Diagnostic-Id";
    @Deprecated
    public static final String SCOPE_KEY = "scope";
    @Deprecated
    public static final String AZ_TRACING_NAMESPACE_KEY = "az.namespace";
    @Deprecated
    public static final String SPAN_BUILDER_KEY = "builder";
    @Deprecated
    public static final String MESSAGE_ENQUEUED_TIME = "x-opt-enqueued-time";
    public static final String DISABLE_TRACING_KEY = "disable-tracing";

    public Context start(String var1, Context var2);

    default public Context start(String methodName, StartSpanOptions options, Context context) {
        return this.start(methodName, context);
    }

    @Deprecated
    default public Context start(String spanName, Context context, ProcessKind processKind) {
        Objects.requireNonNull(spanName, "'spanName' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(processKind, "'processKind' cannot be null.");
        if (!this.isEnabled()) {
            return context;
        }
        switch (processKind) {
            case SEND: {
                StartSpanOptions spanBuilder = Utils.getOrNull(context, SPAN_BUILDER_KEY, StartSpanOptions.class);
                if (spanBuilder == null) {
                    Utils.LOGGER.atWarning().addKeyValue("spanName", spanName).addKeyValue("processKind", (Object)processKind).log("Start span is called without builder on the context, creating default builder.");
                    spanBuilder = new StartSpanOptions(SpanKind.CLIENT);
                }
                Utils.addMessagingAttributes(spanBuilder, context);
                return this.start(spanName, spanBuilder, context);
            }
            case MESSAGE: {
                StartSpanOptions spanBuilder = new StartSpanOptions(SpanKind.PRODUCER);
                Utils.addMessagingAttributes(spanBuilder, context);
                context = this.start(spanName, spanBuilder, context);
                AtomicReference diagnosticId = new AtomicReference();
                this.injectContext((name, value) -> {
                    if (name.equals("traceparent")) {
                        diagnosticId.set(value);
                    }
                }, context);
                return context.addData(DIAGNOSTIC_ID_KEY, diagnosticId);
            }
            case PROCESS: {
                StartSpanOptions spanBuilder = Utils.getOrNull(context, SPAN_BUILDER_KEY, StartSpanOptions.class);
                if (spanBuilder == null) {
                    spanBuilder = new StartSpanOptions(SpanKind.CONSUMER).setRemoteParent(context);
                }
                Utils.addMessagingAttributes(spanBuilder, context);
                return this.start(spanName, spanBuilder, context);
            }
        }
        Utils.LOGGER.atWarning().addKeyValue("spanName", spanName).addKeyValue("processKind", (Object)processKind).log("Start span is called with unknown process kind, suppressing the span.");
        return context;
    }

    @Deprecated
    default public void end(int responseCode, Throwable error, Context context) {
        this.end(null, error, context);
    }

    public void end(String var1, Throwable var2, Context var3);

    public void setAttribute(String var1, String var2, Context var3);

    default public void setAttribute(String key, long value, Context context) {
        this.setAttribute(key, Long.toString(value), context);
    }

    default public void setAttribute(String key, Object value, Context context) {
        Objects.requireNonNull(value, "'value' cannot be null.");
        this.setAttribute(key, value.toString(), context);
    }

    @Deprecated
    default public Context setSpanName(String spanName, Context context) {
        return context;
    }

    @Deprecated
    default public void addLink(Context context) {
        TracingLink link;
        if (!this.isEnabled()) {
            return;
        }
        StartSpanOptions spanBuilder = Utils.getOrNull(context, SPAN_BUILDER_KEY, StartSpanOptions.class);
        if (spanBuilder == null) {
            return;
        }
        Long messageEnqueuedTime = Utils.getOrNull(context, MESSAGE_ENQUEUED_TIME, Long.class);
        if (messageEnqueuedTime != null) {
            HashMap<String, Object> linkAttributes = new HashMap<String, Object>(1);
            linkAttributes.put(MESSAGE_ENQUEUED_TIME, messageEnqueuedTime);
            link = new TracingLink(context, linkAttributes);
        } else {
            link = new TracingLink(context);
        }
        spanBuilder.addLink(link);
    }

    @Deprecated
    default public Context extractContext(String diagnosticId, Context context) {
        return this.extractContext(name -> {
            if (name.equals("traceparent") || name.equals(DIAGNOSTIC_ID_KEY)) {
                return diagnosticId;
            }
            return null;
        });
    }

    default public Context extractContext(Function<String, String> headerGetter) {
        return Context.NONE;
    }

    default public void injectContext(BiConsumer<String, String> headerSetter, Context context) {
    }

    @Deprecated
    default public Context getSharedSpanBuilder(String spanName, Context context) {
        if (!this.isEnabled()) {
            return context;
        }
        SpanKind spanKind = Utils.getOrNull(context, "span-kind", SpanKind.class);
        if (spanKind == null) {
            spanKind = SpanKind.CLIENT;
        }
        StartSpanOptions options = new StartSpanOptions(spanKind);
        Instant startTime = Utils.getOrNull(context, "span-start-time", Instant.class);
        if (startTime != null) {
            options.setStartTimestamp(startTime);
        }
        return context.addData(SPAN_BUILDER_KEY, options);
    }

    @Deprecated
    default public void addEvent(String name, Map<String, Object> attributes, OffsetDateTime timestamp) {
        this.addEvent(name, attributes, timestamp, Context.NONE);
    }

    default public void addEvent(String name, Map<String, Object> attributes, OffsetDateTime timestamp, Context context) {
    }

    default public AutoCloseable makeSpanCurrent(Context context) {
        return NoopTracer.INSTANCE.makeSpanCurrent(context);
    }

    default public boolean isRecording(Context span) {
        return true;
    }

    default public boolean isEnabled() {
        return true;
    }
}

