/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.tracing;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.StartSpanOptions;

final class Utils {
    static final String SPAN_KIND_KEY = "span-kind";
    static final String START_TIME_KEY = "span-start-time";
    static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    static final ClientLogger LOGGER = new ClientLogger(Utils.class);

    private Utils() {
    }

    static void addMessagingAttributes(StartSpanOptions spanOptions, Context context) {
        Long messageEnqueuedTime;
        String hostName;
        String entityPath = Utils.getOrNull(context, "entity-path", String.class);
        if (entityPath != null) {
            spanOptions.setAttribute("entity-path", entityPath);
        }
        if ((hostName = Utils.getOrNull(context, "hostname", String.class)) != null) {
            spanOptions.setAttribute("hostname", hostName);
        }
        if ((messageEnqueuedTime = Utils.getOrNull(context, "x-opt-enqueued-time", Long.class)) != null) {
            spanOptions.setAttribute("x-opt-enqueued-time", messageEnqueuedTime);
        }
    }

    static <T> T getOrNull(Context context, String key, Class<T> clazz) {
        Object data = context.getData(key).orElse(null);
        if (data != null && clazz.isAssignableFrom(data.getClass())) {
            return (T)data;
        }
        return null;
    }
}

