/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.HttpTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.ProxyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.CredentialBuilderBaseHelper;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public abstract class CredentialBuilderBase<T extends CredentialBuilderBase<T>>
implements HttpTrait<T> {
    private static final ClientLogger LOGGER = new ClientLogger(CredentialBuilderBase.class);
    IdentityClientOptions identityClientOptions = new IdentityClientOptions();

    CredentialBuilderBase() {
    }

    public T maxRetry(int maxRetry) {
        this.identityClientOptions.setMaxRetry(maxRetry);
        return (T)this;
    }

    public T retryTimeout(Function<Duration, Duration> retryTimeout) {
        this.identityClientOptions.setRetryTimeout(retryTimeout);
        return (T)this;
    }

    @Deprecated
    public T proxyOptions(ProxyOptions proxyOptions) {
        this.identityClientOptions.setProxyOptions(proxyOptions);
        return (T)this;
    }

    @Deprecated
    public T httpPipeline(HttpPipeline httpPipeline) {
        this.identityClientOptions.setHttpPipeline(httpPipeline);
        return (T)this;
    }

    @Override
    public T httpClient(HttpClient client) {
        Objects.requireNonNull(client);
        this.identityClientOptions.setHttpClient(client);
        return (T)this;
    }

    public T configuration(Configuration configuration) {
        this.identityClientOptions.setConfiguration(configuration);
        return (T)this;
    }

    @Override
    public T clientOptions(ClientOptions clientOptions) {
        this.identityClientOptions.setClientOptions(clientOptions);
        return (T)this;
    }

    @Override
    public T httpLogOptions(HttpLogOptions logOptions) {
        this.identityClientOptions.setHttpLogOptions(logOptions);
        return (T)this;
    }

    public T retryPolicy(RetryPolicy retryPolicy) {
        this.identityClientOptions.setRetryPolicy(retryPolicy);
        return (T)this;
    }

    @Override
    public T retryOptions(RetryOptions retryOptions) {
        this.identityClientOptions.setRetryOptions(retryOptions);
        return (T)this;
    }

    @Override
    public T addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'policy' cannot be null."));
        }
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.identityClientOptions.addPerCallPolicy(policy);
        } else {
            this.identityClientOptions.addPerRetryPolicy(policy);
        }
        return (T)this;
    }

    @Override
    public T pipeline(HttpPipeline pipeline) {
        this.identityClientOptions.setHttpPipeline(pipeline);
        return (T)this;
    }

    public T enableAccountIdentifierLogging() {
        this.identityClientOptions.getIdentityLogOptionsImpl().setLoggingAccountIdentifiersAllowed(true);
        return (T)this;
    }

    static {
        CredentialBuilderBaseHelper.setAccessor(new CredentialBuilderBaseHelper.CredentialBuilderBaseAccessor(){

            @Override
            public IdentityClientOptions getClientOptions(CredentialBuilderBase<?> builder) {
                return builder.identityClientOptions;
            }
        });
    }
}

