/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.AuthenticationRecord;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.MsalAuthenticationAccount;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.MsalToken;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.ValidationUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.concurrent.atomic.AtomicReference;

public class SharedTokenCacheCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(SharedTokenCacheCredential.class);
    private final String username;
    private final String clientId;
    private final String tenantId;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private final IdentityClient identityClient;

    SharedTokenCacheCredential(String username, String clientId, String tenantId, IdentityClientOptions identityClientOptions) {
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        this.username = username == null ? configuration.get("AZURE_USERNAME") : username;
        this.clientId = clientId == null ? configuration.get("AZURE_CLIENT_ID") : clientId;
        if (tenantId == null) {
            this.tenantId = configuration.contains("AZURE_TENANT_ID") ? configuration.get("AZURE_TENANT_ID") : "common";
            ValidationUtil.validateTenantIdCharacterRange(this.tenantId, LOGGER);
        } else {
            this.tenantId = tenantId;
        }
        this.identityClient = new IdentityClientBuilder().tenantId(this.tenantId).clientId(this.clientId).sharedTokenCacheCredential(true).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
        if (identityClientOptions.getAuthenticationRecord() != null) {
            this.cachedToken.set(new MsalAuthenticationAccount(identityClientOptions.getAuthenticationRecord()));
        }
        LoggingUtil.logAvailableEnvironmentVariables(LOGGER, configuration);
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithSharedTokenCache(request, this.username))).map(this::updateCache).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error)).onErrorMap(error -> {
            if (this.identityClient.getIdentityClientOptions().isChained()) {
                return new CredentialUnavailableException(error.getMessage(), (Throwable)error);
            }
            return error;
        });
    }

    private AccessToken updateCache(MsalToken msalToken) {
        this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId())));
        return msalToken;
    }
}

