/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.AccessManagement;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SpringServices;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceCertificateOrders;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceCertificates;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceDomains;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServicePlans;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.FunctionApps;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebApps;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryApplications;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryUsers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleAssignments;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleDefinitions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ServicePrincipals;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.CdnManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CdnProfiles;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.ComputeManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.AvailabilitySets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ComputeSkus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ComputeUsages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.DiskEncryptionSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Disks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Galleries;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryImageVersions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.GalleryImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.Snapshots;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineCustomImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachineScaleSets;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachines;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.ContainerInstanceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.Registries;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTaskRuns;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.RegistryTasks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.ContainerServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.KubernetesClusters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.CosmosManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cosmos.models.CosmosDBAccounts;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.DnsZoneManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.DnsZones;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubDisasterRecoveryPairings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubNamespaces;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.EventHubs;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.ManagedHsms;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Vaults;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.MonitorManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ActionGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.ActivityLogs;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AlertRules;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AutoscaleSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DiagnosticSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricDefinitions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.MsiManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models.Identities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateways;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationSecurityGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.DdosProtectionPlans;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCircuits;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteCrossConnections;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LocalNetworkGateways;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterfaces;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkProfiles;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkUsages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkWatchers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Networks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PrivateEndpoints;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddresses;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpPrefixes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteFilters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteTables;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualNetworkGateways;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.PrivateDnsZoneManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.privatedns.models.PrivateDnsZones;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.RedisManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisCaches;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.ResourceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Deployments;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Features;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.GenericResources;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ManagementLocks;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.PolicyAssignments;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.PolicyDefinitions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Providers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Subscription;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Subscriptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.TagOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Tenants;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.SearchServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchServices;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.ServiceBusNamespaces;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobContainers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobServices;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ManagementPolicies;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccounts;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageSkus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Usages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.TrafficManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfiles;
import java.util.Objects;

public final class AzureResourceManager {
    private final ResourceManager resourceManager;
    private final StorageManager storageManager;
    private final ComputeManager computeManager;
    private final NetworkManager networkManager;
    private final KeyVaultManager keyVaultManager;
    private final TrafficManager trafficManager;
    private final RedisManager redisManager;
    private final CdnManager cdnManager;
    private final DnsZoneManager dnsZoneManager;
    private final AppServiceManager appServiceManager;
    private final SqlServerManager sqlServerManager;
    private final ServiceBusManager serviceBusManager;
    private final ContainerInstanceManager containerInstanceManager;
    private final ContainerRegistryManager containerRegistryManager;
    private final ContainerServiceManager containerServiceManager;
    private final SearchServiceManager searchServiceManager;
    private final CosmosManager cosmosManager;
    private final MsiManager msiManager;
    private final MonitorManager monitorManager;
    private final EventHubsManager eventHubsManager;
    private final AppPlatformManager appPlatformManager;
    private final PrivateDnsZoneManager privateDnsZoneManager;
    private final Authenticated authenticated;
    private final String subscriptionId;
    private final String tenantId;

    public static Authenticated authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new AuthenticatedImpl(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static Authenticated authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new AuthenticatedImpl(httpPipeline, profile);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    private AzureResourceManager(HttpPipeline httpPipeline, AzureProfile profile) {
        this(httpPipeline, profile, AzureResourceManager.authenticate(httpPipeline, profile));
    }

    private AzureResourceManager(HttpPipeline httpPipeline, AzureProfile profile, Authenticated authenticated) {
        this.resourceManager = ResourceManager.authenticate(httpPipeline, profile).withDefaultSubscription();
        this.storageManager = StorageManager.authenticate(httpPipeline, profile);
        this.computeManager = ComputeManager.authenticate(httpPipeline, profile);
        this.networkManager = NetworkManager.authenticate(httpPipeline, profile);
        this.keyVaultManager = KeyVaultManager.authenticate(httpPipeline, profile);
        this.trafficManager = TrafficManager.authenticate(httpPipeline, profile);
        this.redisManager = RedisManager.authenticate(httpPipeline, profile);
        this.cdnManager = CdnManager.authenticate(httpPipeline, profile);
        this.dnsZoneManager = DnsZoneManager.authenticate(httpPipeline, profile);
        this.appServiceManager = AppServiceManager.authenticate(httpPipeline, profile);
        this.sqlServerManager = SqlServerManager.authenticate(httpPipeline, profile);
        this.serviceBusManager = ServiceBusManager.authenticate(httpPipeline, profile);
        this.containerInstanceManager = ContainerInstanceManager.authenticate(httpPipeline, profile);
        this.containerRegistryManager = ContainerRegistryManager.authenticate(httpPipeline, profile);
        this.containerServiceManager = ContainerServiceManager.authenticate(httpPipeline, profile);
        this.cosmosManager = CosmosManager.authenticate(httpPipeline, profile);
        this.searchServiceManager = SearchServiceManager.authenticate(httpPipeline, profile);
        this.msiManager = MsiManager.authenticate(httpPipeline, profile);
        this.monitorManager = MonitorManager.authenticate(httpPipeline, profile);
        this.eventHubsManager = EventHubsManager.authenticate(httpPipeline, profile);
        this.appPlatformManager = AppPlatformManager.authenticate(httpPipeline, profile);
        this.privateDnsZoneManager = PrivateDnsZoneManager.authenticate(httpPipeline, profile);
        this.authenticated = authenticated;
        this.subscriptionId = profile.getSubscriptionId();
        this.tenantId = profile.getTenantId();
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public Subscription getCurrentSubscription() {
        return (Subscription)this.subscriptions().getById(this.subscriptionId());
    }

    public Subscriptions subscriptions() {
        return this.resourceManager.subscriptions();
    }

    public Tenants tenants() {
        return this.resourceManager.tenants();
    }

    public ResourceGroups resourceGroups() {
        return this.resourceManager.resourceGroups();
    }

    public Deployments deployments() {
        return this.resourceManager.deployments();
    }

    public GenericResources genericResources() {
        return this.resourceManager.genericResources();
    }

    public Features features() {
        return this.resourceManager.features();
    }

    public Providers providers() {
        return this.resourceManager.providers();
    }

    public PolicyDefinitions policyDefinitions() {
        return this.resourceManager.policyDefinitions();
    }

    public PolicyAssignments policyAssignments() {
        return this.resourceManager.policyAssignments();
    }

    public ManagementLocks managementLocks() {
        return this.resourceManager.managementLocks();
    }

    public StorageAccounts storageAccounts() {
        return this.storageManager.storageAccounts();
    }

    public Usages storageUsages() {
        return this.storageManager.usages();
    }

    public StorageSkus storageSkus() {
        return this.storageManager.storageSkus();
    }

    public AvailabilitySets availabilitySets() {
        return this.computeManager.availabilitySets();
    }

    public Networks networks() {
        return this.networkManager.networks();
    }

    public RouteTables routeTables() {
        return this.networkManager.routeTables();
    }

    public LoadBalancers loadBalancers() {
        return this.networkManager.loadBalancers();
    }

    public ApplicationGateways applicationGateways() {
        return this.networkManager.applicationGateways();
    }

    public NetworkSecurityGroups networkSecurityGroups() {
        return this.networkManager.networkSecurityGroups();
    }

    public NetworkUsages networkUsages() {
        return this.networkManager.usages();
    }

    public NetworkWatchers networkWatchers() {
        return this.networkManager.networkWatchers();
    }

    public VirtualNetworkGateways virtualNetworkGateways() {
        return this.networkManager.virtualNetworkGateways();
    }

    public LocalNetworkGateways localNetworkGateways() {
        return this.networkManager.localNetworkGateways();
    }

    public ExpressRouteCircuits expressRouteCircuits() {
        return this.networkManager.expressRouteCircuits();
    }

    public ExpressRouteCrossConnections expressRouteCrossConnections() {
        return this.networkManager.expressRouteCrossConnections();
    }

    public ApplicationSecurityGroups applicationSecurityGroups() {
        return this.networkManager.applicationSecurityGroups();
    }

    public RouteFilters routeFilters() {
        return this.networkManager.routeFilters();
    }

    public DdosProtectionPlans ddosProtectionPlans() {
        return this.networkManager.ddosProtectionPlans();
    }

    public VirtualMachines virtualMachines() {
        return this.computeManager.virtualMachines();
    }

    public VirtualMachineScaleSets virtualMachineScaleSets() {
        return this.computeManager.virtualMachineScaleSets();
    }

    public VirtualMachineImages virtualMachineImages() {
        return this.computeManager.virtualMachineImages();
    }

    public VirtualMachineCustomImages virtualMachineCustomImages() {
        return this.computeManager.virtualMachineCustomImages();
    }

    public Disks disks() {
        return this.computeManager.disks();
    }

    public Snapshots snapshots() {
        return this.computeManager.snapshots();
    }

    public ComputeSkus computeSkus() {
        return this.computeManager.computeSkus();
    }

    public PublicIpAddresses publicIpAddresses() {
        return this.networkManager.publicIpAddresses();
    }

    public PublicIpPrefixes publicIpPrefixes() {
        return this.networkManager.publicIpPrefixes();
    }

    public NetworkInterfaces networkInterfaces() {
        return this.networkManager.networkInterfaces();
    }

    public ComputeUsages computeUsages() {
        return this.computeManager.usages();
    }

    public Vaults vaults() {
        return this.keyVaultManager.vaults();
    }

    public TrafficManagerProfiles trafficManagerProfiles() {
        return this.trafficManager.profiles();
    }

    public RedisCaches redisCaches() {
        return this.redisManager.redisCaches();
    }

    public CdnProfiles cdnProfiles() {
        return this.cdnManager.profiles();
    }

    public DnsZones dnsZones() {
        return this.dnsZoneManager.zones();
    }

    public WebApps webApps() {
        return this.appServiceManager.webApps();
    }

    public FunctionApps functionApps() {
        return this.appServiceManager.functionApps();
    }

    public AppServicePlans appServicePlans() {
        return this.appServiceManager.appServicePlans();
    }

    public AppServiceDomains appServiceDomains() {
        return this.appServiceManager.domains();
    }

    public AppServiceCertificates appServiceCertificates() {
        return this.appServiceManager.certificates();
    }

    public AppServiceCertificateOrders appServiceCertificateOrders() {
        return this.appServiceManager.certificateOrders();
    }

    public SqlServers sqlServers() {
        return this.sqlServerManager.sqlServers();
    }

    public ServiceBusNamespaces serviceBusNamespaces() {
        return this.serviceBusManager.namespaces();
    }

    public KubernetesClusters kubernetesClusters() {
        return this.containerServiceManager.kubernetesClusters();
    }

    public ContainerGroups containerGroups() {
        return this.containerInstanceManager.containerGroups();
    }

    public Registries containerRegistries() {
        return this.containerRegistryManager.containerRegistries();
    }

    public RegistryTasks containerRegistryTasks() {
        return this.containerRegistryManager.containerRegistryTasks();
    }

    public RegistryTaskRuns containerRegistryTaskRuns() {
        return this.containerRegistryManager.registryTaskRuns();
    }

    public CosmosDBAccounts cosmosDBAccounts() {
        return this.cosmosManager.databaseAccounts();
    }

    public SearchServices searchServices() {
        return this.searchServiceManager.searchServices();
    }

    public Identities identities() {
        return this.msiManager.identities();
    }

    public AccessManagement accessManagement() {
        return this.authenticated;
    }

    public ActivityLogs activityLogs() {
        return this.monitorManager.activityLogs();
    }

    public MetricDefinitions metricDefinitions() {
        return this.monitorManager.metricDefinitions();
    }

    public DiagnosticSettings diagnosticSettings() {
        return this.monitorManager.diagnosticSettings();
    }

    public ActionGroups actionGroups() {
        return this.monitorManager.actionGroups();
    }

    public AlertRules alertRules() {
        return this.monitorManager.alertRules();
    }

    public AutoscaleSettings autoscaleSettings() {
        return this.monitorManager.autoscaleSettings();
    }

    public EventHubNamespaces eventHubNamespaces() {
        return this.eventHubsManager.namespaces();
    }

    public EventHubs eventHubs() {
        return this.eventHubsManager.eventHubs();
    }

    public EventHubDisasterRecoveryPairings eventHubDisasterRecoveryPairings() {
        return this.eventHubsManager.eventHubDisasterRecoveryPairings();
    }

    public Galleries galleries() {
        return this.computeManager.galleries();
    }

    public GalleryImages galleryImages() {
        return this.computeManager.galleryImages();
    }

    public GalleryImageVersions galleryImageVersions() {
        return this.computeManager.galleryImageVersions();
    }

    public BlobContainers storageBlobContainers() {
        return this.storageManager.blobContainers();
    }

    public BlobServices storageBlobServices() {
        return this.storageManager.blobServices();
    }

    public ManagementPolicies storageManagementPolicies() {
        return this.storageManager.managementPolicies();
    }

    public SpringServices springServices() {
        return this.appPlatformManager.springServices();
    }

    public PrivateDnsZones privateDnsZones() {
        return this.privateDnsZoneManager.privateZones();
    }

    public PrivateEndpoints privateEndpoints() {
        return this.networkManager.privateEndpoints();
    }

    public TagOperations tagOperations() {
        return this.resourceManager.tagOperations();
    }

    public NetworkProfiles networkProfiles() {
        return this.networkManager.networkProfiles();
    }

    public DiskEncryptionSets diskEncryptionSets() {
        return this.computeManager.diskEncryptionSets();
    }

    public ManagedHsms managedHsms() {
        return this.keyVaultManager.managedHsms();
    }

    public static interface Authenticated
    extends AccessManagement {
        public String tenantId();

        public Subscriptions subscriptions();

        public Tenants tenants();

        public Authenticated withTenantId(String var1);

        public AzureResourceManager withSubscription(String var1);

        public AzureResourceManager withDefaultSubscription();
    }

    private static final class AuthenticatedImpl
    implements Authenticated {
        private final HttpPipeline httpPipeline;
        private final ResourceManager.Authenticated resourceManagerAuthenticated;
        private AuthorizationManager authorizationManager;
        private String tenantId;
        private String subscriptionId;
        private final AzureEnvironment environment;

        private AuthenticatedImpl(HttpPipeline httpPipeline, AzureProfile profile) {
            this.resourceManagerAuthenticated = ResourceManager.authenticate(httpPipeline, profile);
            this.authorizationManager = AuthorizationManager.authenticate(httpPipeline, profile);
            this.httpPipeline = httpPipeline;
            this.tenantId = profile.getTenantId();
            this.subscriptionId = profile.getSubscriptionId();
            this.environment = profile.getEnvironment();
        }

        @Override
        public String tenantId() {
            return this.tenantId;
        }

        @Override
        public Subscriptions subscriptions() {
            return this.resourceManagerAuthenticated.subscriptions();
        }

        @Override
        public Tenants tenants() {
            return this.resourceManagerAuthenticated.tenants();
        }

        @Override
        public ActiveDirectoryUsers activeDirectoryUsers() {
            return this.authorizationManager.users();
        }

        @Override
        public ActiveDirectoryGroups activeDirectoryGroups() {
            return this.authorizationManager.groups();
        }

        @Override
        public ServicePrincipals servicePrincipals() {
            return this.authorizationManager.servicePrincipals();
        }

        @Override
        public ActiveDirectoryApplications activeDirectoryApplications() {
            return this.authorizationManager.applications();
        }

        @Override
        public RoleDefinitions roleDefinitions() {
            return this.authorizationManager.roleDefinitions();
        }

        @Override
        public RoleAssignments roleAssignments() {
            return this.authorizationManager.roleAssignments();
        }

        @Override
        public Authenticated withTenantId(String tenantId) {
            Objects.requireNonNull(tenantId);
            this.tenantId = tenantId;
            this.authorizationManager = AuthorizationManager.authenticate(this.httpPipeline, new AzureProfile(tenantId, this.subscriptionId, this.environment));
            return this;
        }

        @Override
        public AzureResourceManager withSubscription(String subscriptionId) {
            return new AzureResourceManager(this.httpPipeline, new AzureProfile(this.tenantId, subscriptionId, this.environment), this);
        }

        @Override
        public AzureResourceManager withDefaultSubscription() {
            if (this.subscriptionId == null) {
                this.subscriptionId = ResourceManagerUtils.getDefaultSubscription(this.subscriptions().list());
            }
            return new AzureResourceManager(this.httpPipeline, new AzureProfile(this.tenantId, this.subscriptionId, this.environment), this);
        }
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public Authenticated authenticate(TokenCredential credential, AzureProfile profile) {
            return AzureResourceManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public Authenticated authenticate(TokenCredential var1, AzureProfile var2);
    }
}

