/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.BuildServiceAgentPoolsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.BuildServiceAgentPoolResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.BuildServiceAgentPoolResourceCollection;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class BuildServiceAgentPoolsClientImpl
implements BuildServiceAgentPoolsClient {
    private final BuildServiceAgentPoolsService service;
    private final AppPlatformManagementClientImpl client;

    BuildServiceAgentPoolsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = RestProxy.create(BuildServiceAgentPoolsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceAgentPoolResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, BuildServiceAgentPoolResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildServiceAgentPoolResourceCollection)res.getValue()).value(), ((BuildServiceAgentPoolResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceAgentPoolResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, "application/json", context).map(res -> new PagedResponseBase<Object, BuildServiceAgentPoolResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildServiceAgentPoolResourceCollection)res.getValue()).value(), ((BuildServiceAgentPoolResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BuildServiceAgentPoolResourceInner> listAsync(String resourceGroupName, String serviceName, String buildServiceName) {
        return new PagedFlux<BuildServiceAgentPoolResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName, buildServiceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BuildServiceAgentPoolResourceInner> listAsync(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return new PagedFlux<BuildServiceAgentPoolResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName, buildServiceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildServiceAgentPoolResourceInner> list(String resourceGroupName, String serviceName, String buildServiceName) {
        return new PagedIterable<BuildServiceAgentPoolResourceInner>(this.listAsync(resourceGroupName, serviceName, buildServiceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BuildServiceAgentPoolResourceInner> list(String resourceGroupName, String serviceName, String buildServiceName, Context context) {
        return new PagedIterable<BuildServiceAgentPoolResourceInner>(this.listAsync(resourceGroupName, serviceName, buildServiceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BuildServiceAgentPoolResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, agentPoolName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BuildServiceAgentPoolResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, agentPoolName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildServiceAgentPoolResourceInner> getAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName).flatMap(res -> Mono.justOrEmpty((BuildServiceAgentPoolResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BuildServiceAgentPoolResourceInner> getWithResponse(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildServiceAgentPoolResourceInner get(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName) {
        return this.getWithResponse(resourceGroupName, serviceName, buildServiceName, agentPoolName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolResource is required and cannot be null."));
        }
        agentPoolResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (buildServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter buildServiceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolResource is required and cannot be null."));
        }
        agentPoolResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BuildServiceAgentPoolResourceInner>, BuildServiceAgentPoolResourceInner> beginUpdatePutAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePutWithResponseAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BuildServiceAgentPoolResourceInner.class), (Type)((Object)BuildServiceAgentPoolResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BuildServiceAgentPoolResourceInner>, BuildServiceAgentPoolResourceInner> beginUpdatePutAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePutWithResponseAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BuildServiceAgentPoolResourceInner.class), (Type)((Object)BuildServiceAgentPoolResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuildServiceAgentPoolResourceInner>, BuildServiceAgentPoolResourceInner> beginUpdatePut(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BuildServiceAgentPoolResourceInner>, BuildServiceAgentPoolResourceInner> beginUpdatePut(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BuildServiceAgentPoolResourceInner> updatePutAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BuildServiceAgentPoolResourceInner> updatePutAsync(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildServiceAgentPoolResourceInner updatePut(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource) {
        return this.updatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BuildServiceAgentPoolResourceInner updatePut(String resourceGroupName, String serviceName, String buildServiceName, String agentPoolName, BuildServiceAgentPoolResourceInner agentPoolResource, Context context) {
        return this.updatePutAsync(resourceGroupName, serviceName, buildServiceName, agentPoolName, agentPoolResource, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceAgentPoolResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, BuildServiceAgentPoolResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildServiceAgentPoolResourceCollection)res.getValue()).value(), ((BuildServiceAgentPoolResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BuildServiceAgentPoolResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, BuildServiceAgentPoolResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BuildServiceAgentPoolResourceCollection)res.getValue()).value(), ((BuildServiceAgentPoolResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface BuildServiceAgentPoolsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/agentPools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildServiceAgentPoolResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildServiceAgentPoolResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="agentPoolName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updatePut(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="buildServiceName") String var6, @PathParam(value="agentPoolName") String var7, @BodyParam(value="application/json") BuildServiceAgentPoolResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BuildServiceAgentPoolResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

