/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.ConfigurationServiceResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.Utils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ConfigurationServiceGitProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ConfigurationServiceGitRepository;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SpringApp;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SpringConfigurationService;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.SpringService;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SpringConfigurationServiceImpl
extends ExternalChildResourceImpl<SpringConfigurationService, ConfigurationServiceResourceInner, SpringServiceImpl, SpringService>
implements SpringConfigurationService {
    protected SpringConfigurationServiceImpl(String name, SpringServiceImpl parent, ConfigurationServiceResourceInner innerObject) {
        super(name, parent, innerObject);
    }

    @Override
    public Double cpu() {
        return Utils.fromCpuString(((ConfigurationServiceResourceInner)this.innerModel()).properties().resourceRequests().cpu());
    }

    @Override
    public Double memory() {
        return Utils.fromMemoryString(((ConfigurationServiceResourceInner)this.innerModel()).properties().resourceRequests().memory());
    }

    @Override
    public String gitUri() {
        return this.findDefaultRepository().map(ConfigurationServiceGitRepository::uri).orElse(null);
    }

    @Override
    public List<String> filePatterns() {
        return this.findDefaultRepository().map(ConfigurationServiceGitRepository::patterns).orElse(Collections.emptyList());
    }

    @Override
    public String branch() {
        return this.findDefaultRepository().map(ConfigurationServiceGitRepository::label).orElse(null);
    }

    @Override
    public ConfigurationServiceGitRepository getGitRepository(String name) {
        return this.findRepository(name).orElse(null);
    }

    private Optional<ConfigurationServiceGitRepository> findDefaultRepository() {
        return this.findRepository("default");
    }

    @Override
    public List<SpringApp> getAppBindings() {
        return ((SpringServiceImpl)this.parent()).apps().list().stream().filter(SpringApp::hasConfigurationServiceBinding).collect(Collectors.toList());
    }

    private Optional<ConfigurationServiceGitRepository> findRepository(String name) {
        if (name == null || ((ConfigurationServiceResourceInner)this.innerModel()).properties() == null || ((ConfigurationServiceResourceInner)this.innerModel()).properties().settings() == null) {
            return Optional.empty();
        }
        ConfigurationServiceGitProperty property = ((ConfigurationServiceResourceInner)this.innerModel()).properties().settings().gitProperty();
        if (property != null && property.repositories() != null) {
            return property.repositories().stream().filter(repository -> name.equals(repository.name())).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public String id() {
        return ((ConfigurationServiceResourceInner)this.innerModel()).id();
    }

    @Override
    public Mono<SpringConfigurationService> createResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getConfigurationServices().createOrUpdateAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name(), (ConfigurationServiceResourceInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    @Override
    public Mono<SpringConfigurationService> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getConfigurationServices().deleteAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    @Override
    protected Mono<ConfigurationServiceResourceInner> getInnerAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getConfigurationServices().getAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    public AppPlatformManager manager() {
        return (AppPlatformManager)((SpringServiceImpl)this.parent()).manager();
    }
}

