/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ApmProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class ApmProperties
implements JsonSerializable<ApmProperties> {
    private String type;
    private ApmProvisioningState provisioningState;
    private Map<String, String> properties;
    private Map<String, String> secrets;
    private static final ClientLogger LOGGER = new ClientLogger(ApmProperties.class);

    public String type() {
        return this.type;
    }

    public ApmProperties withType(String type) {
        this.type = type;
        return this;
    }

    public ApmProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public ApmProperties withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> secrets() {
        return this.secrets;
    }

    public ApmProperties withSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model ApmProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeMapField("secrets", this.secrets, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static ApmProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApmProperties deserializedApmProperties = new ApmProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedApmProperties.type = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApmProperties.provisioningState = ApmProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map<String, String> properties = reader.readMap(reader1 -> reader1.getString());
                    deserializedApmProperties.properties = properties;
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    Map<String, String> secrets = reader.readMap(reader1 -> reader1.getString());
                    deserializedApmProperties.secrets = secrets;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApmProperties;
        });
    }
}

