/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.LogSpecification;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.MetricSpecification;
import java.io.IOException;
import java.util.List;

public final class ServiceSpecification
implements JsonSerializable<ServiceSpecification> {
    private List<LogSpecification> logSpecifications;
    private List<MetricSpecification> metricSpecifications;

    public List<LogSpecification> logSpecifications() {
        return this.logSpecifications;
    }

    public ServiceSpecification withLogSpecifications(List<LogSpecification> logSpecifications) {
        this.logSpecifications = logSpecifications;
        return this;
    }

    public List<MetricSpecification> metricSpecifications() {
        return this.metricSpecifications;
    }

    public ServiceSpecification withMetricSpecifications(List<MetricSpecification> metricSpecifications) {
        this.metricSpecifications = metricSpecifications;
        return this;
    }

    public void validate() {
        if (this.logSpecifications() != null) {
            this.logSpecifications().forEach(e -> e.validate());
        }
        if (this.metricSpecifications() != null) {
            this.metricSpecifications().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("logSpecifications", this.logSpecifications, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("metricSpecifications", this.metricSpecifications, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ServiceSpecification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceSpecification deserializedServiceSpecification = new ServiceSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logSpecifications".equals(fieldName)) {
                    List<LogSpecification> logSpecifications = reader.readArray(reader1 -> LogSpecification.fromJson(reader1));
                    deserializedServiceSpecification.logSpecifications = logSpecifications;
                    continue;
                }
                if ("metricSpecifications".equals(fieldName)) {
                    List<MetricSpecification> metricSpecifications = reader.readArray(reader1 -> MetricSpecification.fromJson(reader1));
                    deserializedServiceSpecification.metricSpecifications = metricSpecifications;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceSpecification;
        });
    }
}

