/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.StorageProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.StorageType;
import java.io.IOException;

public final class StorageAccount
extends StorageProperties {
    private StorageType storageType = StorageType.STORAGE_ACCOUNT;
    private String accountName;
    private String accountKey;
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccount.class);

    @Override
    public StorageType storageType() {
        return this.storageType;
    }

    public String accountName() {
        return this.accountName;
    }

    public StorageAccount withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String accountKey() {
        return this.accountKey;
    }

    public StorageAccount withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.accountName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property accountName in model StorageAccount"));
        }
        if (this.accountKey() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property accountKey in model StorageAccount"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("storageType", this.storageType == null ? null : this.storageType.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageAccount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccount deserializedStorageAccount = new StorageAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedStorageAccount.accountName = reader.getString();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedStorageAccount.accountKey = reader.getString();
                    continue;
                }
                if ("storageType".equals(fieldName)) {
                    deserializedStorageAccount.storageType = StorageType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccount;
        });
    }
}

