/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.StackMajorVersion;
import java.io.IOException;
import java.util.List;

public final class ApplicationStack
implements JsonSerializable<ApplicationStack> {
    private String name;
    private String display;
    private String dependency;
    private List<StackMajorVersion> majorVersions;
    private List<ApplicationStack> frameworks;
    private List<ApplicationStack> isDeprecated;

    public String name() {
        return this.name;
    }

    public ApplicationStack withName(String name) {
        this.name = name;
        return this;
    }

    public String display() {
        return this.display;
    }

    public ApplicationStack withDisplay(String display) {
        this.display = display;
        return this;
    }

    public String dependency() {
        return this.dependency;
    }

    public ApplicationStack withDependency(String dependency) {
        this.dependency = dependency;
        return this;
    }

    public List<StackMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    public ApplicationStack withMajorVersions(List<StackMajorVersion> majorVersions) {
        this.majorVersions = majorVersions;
        return this;
    }

    public List<ApplicationStack> frameworks() {
        return this.frameworks;
    }

    public ApplicationStack withFrameworks(List<ApplicationStack> frameworks) {
        this.frameworks = frameworks;
        return this;
    }

    public List<ApplicationStack> isDeprecated() {
        return this.isDeprecated;
    }

    public ApplicationStack withIsDeprecated(List<ApplicationStack> isDeprecated) {
        this.isDeprecated = isDeprecated;
        return this;
    }

    public void validate() {
        if (this.majorVersions() != null) {
            this.majorVersions().forEach(e -> e.validate());
        }
        if (this.frameworks() != null) {
            this.frameworks().forEach(e -> e.validate());
        }
        if (this.isDeprecated() != null) {
            this.isDeprecated().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("display", this.display);
        jsonWriter.writeStringField("dependency", this.dependency);
        jsonWriter.writeArrayField("majorVersions", this.majorVersions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("frameworks", this.frameworks, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("isDeprecated", this.isDeprecated, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationStack fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationStack deserializedApplicationStack = new ApplicationStack();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationStack.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedApplicationStack.display = reader.getString();
                    continue;
                }
                if ("dependency".equals(fieldName)) {
                    deserializedApplicationStack.dependency = reader.getString();
                    continue;
                }
                if ("majorVersions".equals(fieldName)) {
                    List<StackMajorVersion> majorVersions = reader.readArray(reader1 -> StackMajorVersion.fromJson(reader1));
                    deserializedApplicationStack.majorVersions = majorVersions;
                    continue;
                }
                if ("frameworks".equals(fieldName)) {
                    List<ApplicationStack> frameworks = reader.readArray(reader1 -> ApplicationStack.fromJson(reader1));
                    deserializedApplicationStack.frameworks = frameworks;
                    continue;
                }
                if ("isDeprecated".equals(fieldName)) {
                    List<ApplicationStack> isDeprecated = reader.readArray(reader1 -> ApplicationStack.fromJson(reader1));
                    deserializedApplicationStack.isDeprecated = isDeprecated;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationStack;
        });
    }
}

