/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.BackupSchedule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import java.io.IOException;
import java.util.List;

public final class BackupRequestProperties
implements JsonSerializable<BackupRequestProperties> {
    private String backupName;
    private Boolean enabled;
    private String storageAccountUrl;
    private BackupSchedule backupSchedule;
    private List<DatabaseBackupSetting> databases;
    private static final ClientLogger LOGGER = new ClientLogger(BackupRequestProperties.class);

    public String backupName() {
        return this.backupName;
    }

    public BackupRequestProperties withBackupName(String backupName) {
        this.backupName = backupName;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public BackupRequestProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    public BackupRequestProperties withStorageAccountUrl(String storageAccountUrl) {
        this.storageAccountUrl = storageAccountUrl;
        return this;
    }

    public BackupSchedule backupSchedule() {
        return this.backupSchedule;
    }

    public BackupRequestProperties withBackupSchedule(BackupSchedule backupSchedule) {
        this.backupSchedule = backupSchedule;
        return this;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    public BackupRequestProperties withDatabases(List<DatabaseBackupSetting> databases) {
        this.databases = databases;
        return this;
    }

    public void validate() {
        if (this.storageAccountUrl() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property storageAccountUrl in model BackupRequestProperties"));
        }
        if (this.backupSchedule() != null) {
            this.backupSchedule().validate();
        }
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountUrl", this.storageAccountUrl);
        jsonWriter.writeStringField("backupName", this.backupName);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("backupSchedule", this.backupSchedule);
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static BackupRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupRequestProperties deserializedBackupRequestProperties = new BackupRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountUrl".equals(fieldName)) {
                    deserializedBackupRequestProperties.storageAccountUrl = reader.getString();
                    continue;
                }
                if ("backupName".equals(fieldName)) {
                    deserializedBackupRequestProperties.backupName = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedBackupRequestProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("backupSchedule".equals(fieldName)) {
                    deserializedBackupRequestProperties.backupSchedule = BackupSchedule.fromJson(reader);
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List<DatabaseBackupSetting> databases = reader.readArray(reader1 -> DatabaseBackupSetting.fromJson(reader1));
                    deserializedBackupRequestProperties.databases = databases;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupRequestProperties;
        });
    }
}

