/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.CertificateProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class CertificateInner
extends Resource {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private CertificateProperties innerProperties;
    private String kind;
    private String type;
    private String name;
    private String id;

    private CertificateProperties innerProperties() {
        return this.innerProperties;
    }

    public String kind() {
        return this.kind;
    }

    public CertificateInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CertificateInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public CertificateInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    public CertificateInner withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    public String friendlyName() {
        return this.innerProperties() == null ? null : this.innerProperties().friendlyName();
    }

    public String subjectName() {
        return this.innerProperties() == null ? null : this.innerProperties().subjectName();
    }

    public List<String> hostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().hostNames();
    }

    public CertificateInner withHostNames(List<String> hostNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withHostNames(hostNames);
        return this;
    }

    public byte[] pfxBlob() {
        return this.innerProperties() == null ? EMPTY_BYTE_ARRAY : this.innerProperties().pfxBlob();
    }

    public CertificateInner withPfxBlob(byte[] pfxBlob) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withPfxBlob(pfxBlob);
        return this;
    }

    public String siteName() {
        return this.innerProperties() == null ? null : this.innerProperties().siteName();
    }

    public String selfLink() {
        return this.innerProperties() == null ? null : this.innerProperties().selfLink();
    }

    public String issuer() {
        return this.innerProperties() == null ? null : this.innerProperties().issuer();
    }

    public OffsetDateTime issueDate() {
        return this.innerProperties() == null ? null : this.innerProperties().issueDate();
    }

    public OffsetDateTime expirationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationDate();
    }

    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    public Boolean valid() {
        return this.innerProperties() == null ? null : this.innerProperties().valid();
    }

    public byte[] cerBlob() {
        return this.innerProperties() == null ? EMPTY_BYTE_ARRAY : this.innerProperties().cerBlob();
    }

    public String publicKeyHash() {
        return this.innerProperties() == null ? null : this.innerProperties().publicKeyHash();
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingEnvironmentProfile();
    }

    public String keyVaultId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultId();
    }

    public CertificateInner withKeyVaultId(String keyVaultId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withKeyVaultId(keyVaultId);
        return this;
    }

    public String keyVaultSecretName() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultSecretName();
    }

    public CertificateInner withKeyVaultSecretName(String keyVaultSecretName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withKeyVaultSecretName(keyVaultSecretName);
        return this;
    }

    public KeyVaultSecretStatus keyVaultSecretStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultSecretStatus();
    }

    public String serverFarmId() {
        return this.innerProperties() == null ? null : this.innerProperties().serverFarmId();
    }

    public CertificateInner withServerFarmId(String serverFarmId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withServerFarmId(serverFarmId);
        return this;
    }

    public String canonicalName() {
        return this.innerProperties() == null ? null : this.innerProperties().canonicalName();
    }

    public CertificateInner withCanonicalName(String canonicalName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withCanonicalName(canonicalName);
        return this;
    }

    public String domainValidationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().domainValidationMethod();
    }

    public CertificateInner withDomainValidationMethod(String domainValidationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withDomainValidationMethod(domainValidationMethod);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static CertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateInner deserializedCertificateInner = new CertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificateInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCertificateInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCertificateInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCertificateInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCertificateInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCertificateInner.innerProperties = CertificateProperties.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedCertificateInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateInner;
        });
    }
}

