/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.BackupRestoreOperationType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import java.io.IOException;
import java.util.List;

public final class RestoreRequestProperties
implements JsonSerializable<RestoreRequestProperties> {
    private String storageAccountUrl;
    private String blobName;
    private boolean overwrite;
    private String siteName;
    private List<DatabaseBackupSetting> databases;
    private Boolean ignoreConflictingHostNames;
    private Boolean ignoreDatabases;
    private String appServicePlan;
    private BackupRestoreOperationType operationType;
    private Boolean adjustConnectionStrings;
    private String hostingEnvironment;
    private static final ClientLogger LOGGER = new ClientLogger(RestoreRequestProperties.class);

    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    public RestoreRequestProperties withStorageAccountUrl(String storageAccountUrl) {
        this.storageAccountUrl = storageAccountUrl;
        return this;
    }

    public String blobName() {
        return this.blobName;
    }

    public RestoreRequestProperties withBlobName(String blobName) {
        this.blobName = blobName;
        return this;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public RestoreRequestProperties withOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public String siteName() {
        return this.siteName;
    }

    public RestoreRequestProperties withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    public RestoreRequestProperties withDatabases(List<DatabaseBackupSetting> databases) {
        this.databases = databases;
        return this;
    }

    public Boolean ignoreConflictingHostNames() {
        return this.ignoreConflictingHostNames;
    }

    public RestoreRequestProperties withIgnoreConflictingHostNames(Boolean ignoreConflictingHostNames) {
        this.ignoreConflictingHostNames = ignoreConflictingHostNames;
        return this;
    }

    public Boolean ignoreDatabases() {
        return this.ignoreDatabases;
    }

    public RestoreRequestProperties withIgnoreDatabases(Boolean ignoreDatabases) {
        this.ignoreDatabases = ignoreDatabases;
        return this;
    }

    public String appServicePlan() {
        return this.appServicePlan;
    }

    public RestoreRequestProperties withAppServicePlan(String appServicePlan) {
        this.appServicePlan = appServicePlan;
        return this;
    }

    public BackupRestoreOperationType operationType() {
        return this.operationType;
    }

    public RestoreRequestProperties withOperationType(BackupRestoreOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    public Boolean adjustConnectionStrings() {
        return this.adjustConnectionStrings;
    }

    public RestoreRequestProperties withAdjustConnectionStrings(Boolean adjustConnectionStrings) {
        this.adjustConnectionStrings = adjustConnectionStrings;
        return this;
    }

    public String hostingEnvironment() {
        return this.hostingEnvironment;
    }

    public RestoreRequestProperties withHostingEnvironment(String hostingEnvironment) {
        this.hostingEnvironment = hostingEnvironment;
        return this;
    }

    public void validate() {
        if (this.storageAccountUrl() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property storageAccountUrl in model RestoreRequestProperties"));
        }
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountUrl", this.storageAccountUrl);
        jsonWriter.writeBooleanField("overwrite", this.overwrite);
        jsonWriter.writeStringField("blobName", this.blobName);
        jsonWriter.writeStringField("siteName", this.siteName);
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("ignoreConflictingHostNames", this.ignoreConflictingHostNames);
        jsonWriter.writeBooleanField("ignoreDatabases", this.ignoreDatabases);
        jsonWriter.writeStringField("appServicePlan", this.appServicePlan);
        jsonWriter.writeStringField("operationType", this.operationType == null ? null : this.operationType.toString());
        jsonWriter.writeBooleanField("adjustConnectionStrings", this.adjustConnectionStrings);
        jsonWriter.writeStringField("hostingEnvironment", this.hostingEnvironment);
        return jsonWriter.writeEndObject();
    }

    public static RestoreRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestoreRequestProperties deserializedRestoreRequestProperties = new RestoreRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountUrl".equals(fieldName)) {
                    deserializedRestoreRequestProperties.storageAccountUrl = reader.getString();
                    continue;
                }
                if ("overwrite".equals(fieldName)) {
                    deserializedRestoreRequestProperties.overwrite = reader.getBoolean();
                    continue;
                }
                if ("blobName".equals(fieldName)) {
                    deserializedRestoreRequestProperties.blobName = reader.getString();
                    continue;
                }
                if ("siteName".equals(fieldName)) {
                    deserializedRestoreRequestProperties.siteName = reader.getString();
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List<DatabaseBackupSetting> databases = reader.readArray(reader1 -> DatabaseBackupSetting.fromJson(reader1));
                    deserializedRestoreRequestProperties.databases = databases;
                    continue;
                }
                if ("ignoreConflictingHostNames".equals(fieldName)) {
                    deserializedRestoreRequestProperties.ignoreConflictingHostNames = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ignoreDatabases".equals(fieldName)) {
                    deserializedRestoreRequestProperties.ignoreDatabases = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appServicePlan".equals(fieldName)) {
                    deserializedRestoreRequestProperties.appServicePlan = reader.getString();
                    continue;
                }
                if ("operationType".equals(fieldName)) {
                    deserializedRestoreRequestProperties.operationType = BackupRestoreOperationType.fromString(reader.getString());
                    continue;
                }
                if ("adjustConnectionStrings".equals(fieldName)) {
                    deserializedRestoreRequestProperties.adjustConnectionStrings = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hostingEnvironment".equals(fieldName)) {
                    deserializedRestoreRequestProperties.hostingEnvironment = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreRequestProperties;
        });
    }
}

