/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.CertificatesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.CertificateInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.Utils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceCertificate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServiceCertificateOrder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;

class AppServiceCertificateImpl
extends GroupableResourceImpl<AppServiceCertificate, CertificateInner, AppServiceCertificateImpl, AppServiceManager>
implements AppServiceCertificate,
AppServiceCertificate.Definition {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private String pfxFileUrl;
    private AppServiceCertificateOrder certificateOrder;

    AppServiceCertificateImpl(String name, CertificateInner innerObject, AppServiceManager manager) {
        super(name, innerObject, manager);
    }

    @Override
    public String friendlyName() {
        return ((CertificateInner)this.innerModel()).friendlyName();
    }

    @Override
    public String subjectName() {
        return ((CertificateInner)this.innerModel()).subjectName();
    }

    @Override
    public List<String> hostNames() {
        return Collections.unmodifiableList(((CertificateInner)this.innerModel()).hostNames());
    }

    @Override
    public byte[] pfxBlob() {
        return ((CertificateInner)this.innerModel()).pfxBlob();
    }

    @Override
    public String siteName() {
        return ((CertificateInner)this.innerModel()).siteName();
    }

    @Override
    public String selfLink() {
        return ((CertificateInner)this.innerModel()).selfLink();
    }

    @Override
    public String issuer() {
        return ((CertificateInner)this.innerModel()).issuer();
    }

    @Override
    public OffsetDateTime issueDate() {
        return ((CertificateInner)this.innerModel()).issueDate();
    }

    @Override
    public OffsetDateTime expirationDate() {
        return ((CertificateInner)this.innerModel()).expirationDate();
    }

    @Override
    public String password() {
        return ((CertificateInner)this.innerModel()).password();
    }

    @Override
    public String thumbprint() {
        return ((CertificateInner)this.innerModel()).thumbprint();
    }

    @Override
    public Boolean valid() {
        return ((CertificateInner)this.innerModel()).valid();
    }

    @Override
    public byte[] certificateBlob() {
        return ((CertificateInner)this.innerModel()).cerBlob();
    }

    @Override
    public String publicKeyHash() {
        return ((CertificateInner)this.innerModel()).publicKeyHash();
    }

    @Override
    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return ((CertificateInner)this.innerModel()).hostingEnvironmentProfile();
    }

    @Override
    protected Mono<CertificateInner> getInnerAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getCertificates().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<AppServiceCertificate> createResourceAsync() {
        Mono<Object> pfxBytes = Mono.empty();
        if (this.pfxFileUrl != null) {
            pfxBytes = Utils.downloadFileAsync(this.pfxFileUrl, ((AppServiceManager)this.manager()).httpPipeline()).map(bytes -> {
                ((CertificateInner)this.innerModel()).withPfxBlob((byte[])bytes);
                return null;
            });
        }
        Mono<Object> keyVaultBinding = Mono.empty();
        if (this.certificateOrder != null) {
            keyVaultBinding = this.certificateOrder.getKeyVaultBindingAsync().map(keyVaultBinding1 -> {
                ((CertificateInner)this.innerModel()).withKeyVaultId(keyVaultBinding1.keyVaultId()).withKeyVaultSecretName(keyVaultBinding1.keyVaultSecretName());
                return null;
            });
        }
        CertificatesClient client = ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getCertificates();
        return pfxBytes.then(keyVaultBinding).then(client.createOrUpdateAsync(this.resourceGroupName(), this.name(), (CertificateInner)this.innerModel())).map(this.innerToFluentMap(this));
    }

    @Override
    public AppServiceCertificateImpl withPfxFile(File file) {
        try {
            byte[] fileContent = Files.readAllBytes(file.toPath());
            return this.withPfxByteArray(fileContent);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    public AppServiceCertificateImpl withPfxByteArray(byte[] pfxByteArray) {
        ((CertificateInner)this.innerModel()).withPfxBlob(pfxByteArray);
        return this;
    }

    @Override
    public AppServiceCertificateImpl withPfxFileFromUrl(String url) {
        this.pfxFileUrl = url;
        return this;
    }

    @Override
    public AppServiceCertificateImpl withExistingCertificateOrder(AppServiceCertificateOrder certificateOrder) {
        this.certificateOrder = certificateOrder;
        return this;
    }

    @Override
    public AppServiceCertificateImpl withPfxPassword(String password) {
        ((CertificateInner)this.innerModel()).withPassword(password);
        return this;
    }
}

