/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.AppServicePlanInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.PricingTier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class AppServicePlanImpl
extends GroupableResourceImpl<AppServicePlan, AppServicePlanInner, AppServicePlanImpl, AppServiceManager>
implements AppServicePlan,
AppServicePlan.Definition,
AppServicePlan.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    AppServicePlanImpl(String name, AppServicePlanInner innerObject, AppServiceManager manager) {
        super(name, innerObject, manager);
    }

    @Override
    public Mono<AppServicePlan> createResourceAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServicePlans().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AppServicePlanInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<AppServicePlanInner> getInnerAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServicePlans().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public int maxInstances() {
        return ResourceManagerUtils.toPrimitiveInt(((AppServicePlanInner)this.innerModel()).maximumNumberOfWorkers());
    }

    @Override
    public int capacity() {
        return ResourceManagerUtils.toPrimitiveInt(((AppServicePlanInner)this.innerModel()).sku().capacity());
    }

    @Override
    public boolean perSiteScaling() {
        return ((AppServicePlanInner)this.innerModel()).perSiteScaling();
    }

    @Override
    public int numberOfWebApps() {
        return ResourceManagerUtils.toPrimitiveInt(((AppServicePlanInner)this.innerModel()).numberOfSites());
    }

    @Override
    public PricingTier pricingTier() {
        return PricingTier.fromSkuDescription(((AppServicePlanInner)this.innerModel()).sku());
    }

    @Override
    public OperatingSystem operatingSystem() {
        return ((AppServicePlanInner)this.innerModel()).reserved() == null || ((AppServicePlanInner)this.innerModel()).reserved() == false ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
    }

    @Override
    public AppServicePlanImpl withFreePricingTier() {
        return this.withPricingTier(PricingTier.FREE_F1);
    }

    @Override
    public AppServicePlanImpl withSharedPricingTier() {
        return this.withPricingTier(PricingTier.SHARED_D1);
    }

    @Override
    public AppServicePlanImpl withPricingTier(PricingTier pricingTier) {
        if (pricingTier == null) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("pricingTier == null"));
        }
        ((AppServicePlanInner)this.innerModel()).withSku(pricingTier.toSkuDescription());
        return this;
    }

    @Override
    public AppServicePlanImpl withPerSiteScaling(boolean perSiteScaling) {
        ((AppServicePlanInner)this.innerModel()).withPerSiteScaling(perSiteScaling);
        return this;
    }

    @Override
    public AppServicePlanImpl withCapacity(int capacity) {
        if (capacity < 1) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Capacity is at least 1."));
        }
        ((AppServicePlanInner)this.innerModel()).sku().withCapacity(capacity);
        return this;
    }

    @Override
    public AppServicePlanImpl withOperatingSystem(OperatingSystem operatingSystem) {
        if (OperatingSystem.LINUX.equals((Object)operatingSystem)) {
            ((AppServicePlanInner)this.innerModel()).withReserved(true);
            ((AppServicePlanInner)this.innerModel()).withKind("linux");
        } else {
            ((AppServicePlanInner)this.innerModel()).withKind("app");
        }
        return this;
    }
}

