/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.AppServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.ConnectionStringDictionaryInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.HostnameBindingInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.IdentifierInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.MSDeployStatusInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.SlotConfigNamesResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.AppServiceBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.HostnameBindingImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.PublishingProfileImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.Utils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebAppSourceControlImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppSetting;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ConnectionString;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.CsmSlotEntity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.HostnameBinding;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.MSDeploy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.PublishingProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppBase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.WebAppSourceControl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class DeploymentSlotBaseImpl<FluentT extends WebAppBase, FluentImplT extends DeploymentSlotBaseImpl<FluentT, FluentImplT, ParentImplT, FluentWithCreateT, FluentUpdateT>, ParentImplT extends AppServiceBaseImpl<?, ?, ?, ?>, FluentWithCreateT, FluentUpdateT>
extends WebAppBaseImpl<FluentT, FluentImplT>
implements DeploymentSlotBase<FluentT>,
DeploymentSlotBase.Update<FluentT> {
    private final ParentImplT parent;
    private final String name;
    WebAppBase configurationSource;

    DeploymentSlotBaseImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, ParentImplT parent) {
        super(name.replaceAll(".*/", ""), innerObject, siteConfig, logConfig, (AppServiceManager)((GroupableResourceImpl)parent).manager());
        this.name = name.replaceAll(".*/", "");
        this.parent = parent;
        ((SiteInner)this.innerModel()).withServerFarmId(((WebAppBaseImpl)parent).appServicePlanId());
        ((SiteInner)this.innerModel()).withLocation(this.regionName());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Map<String, HostnameBinding> getHostnameBindings() {
        return this.getHostnameBindingsAsync().block();
    }

    @Override
    public Mono<Map<String, HostnameBinding>> getHostnameBindingsAsync() {
        return PagedConverter.mapPage(((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listHostnameBindingsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()), hostNameBindingInner -> new HostnameBindingImpl((HostnameBindingInner)hostNameBindingInner, this)).collectList().map(hostNameBindings -> Collections.unmodifiableMap(hostNameBindings.stream().collect(Collectors.toMap(binding -> binding.name().replace(this.name() + "/", ""), Function.identity()))));
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return this.getPublishingProfileAsync().block();
    }

    @Override
    public Mono<PublishingProfile> getPublishingProfileAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listPublishingProfileXmlWithSecretsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), new CsmPublishingProfileOptions()).map(binaryData -> new PublishingProfileImpl(binaryData.toString(), this));
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().startSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void stop() {
        this.stopAsync().block();
    }

    @Override
    public Mono<Void> stopAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().stopSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void restart() {
        this.restartAsync().block();
    }

    @Override
    public Mono<Void> restartAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().restartSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    public FluentImplT withBrandNewConfiguration() {
        this.siteConfig = null;
        return (FluentImplT)this;
    }

    public FluentImplT withConfigurationFromDeploymentSlot(FluentT slot) {
        this.siteConfig = ((WebAppBaseImpl)slot).siteConfig;
        this.configurationSource = slot;
        return (FluentImplT)this;
    }

    @Override
    Mono<Indexable> submitAppSettings() {
        return Mono.justOrEmpty(this.configurationSource).flatMap(webAppBase -> {
            if (!this.isInCreateMode()) {
                return DeploymentSlotBaseImpl.super.submitAppSettings();
            }
            return webAppBase.getAppSettingsAsync().flatMap(stringAppSettingMap -> {
                for (AppSetting appSetting : stringAppSettingMap.values()) {
                    if (appSetting.sticky()) {
                        this.withStickyAppSetting(appSetting.key(), appSetting.value());
                        continue;
                    }
                    this.withAppSetting(appSetting.key(), appSetting.value());
                }
                return DeploymentSlotBaseImpl.super.submitAppSettings();
            });
        }).switchIfEmpty(DeploymentSlotBaseImpl.super.submitAppSettings());
    }

    @Override
    Mono<Indexable> submitConnectionStrings() {
        return Mono.justOrEmpty(this.configurationSource).flatMap(webAppBase -> {
            if (!this.isInCreateMode()) {
                return DeploymentSlotBaseImpl.super.submitConnectionStrings();
            }
            return webAppBase.getConnectionStringsAsync().flatMap(stringConnectionStringMap -> {
                for (ConnectionString connectionString : stringConnectionStringMap.values()) {
                    if (connectionString.sticky()) {
                        this.withStickyConnectionString(connectionString.name(), connectionString.value(), connectionString.type());
                        continue;
                    }
                    this.withConnectionString(connectionString.name(), connectionString.value(), connectionString.type());
                }
                return DeploymentSlotBaseImpl.super.submitConnectionStrings();
            });
        }).switchIfEmpty(DeploymentSlotBaseImpl.super.submitConnectionStrings());
    }

    public ParentImplT parent() {
        return this.parent;
    }

    @Override
    Mono<SiteInner> createOrUpdateInner(SiteInner site) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createOrUpdateSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), site);
    }

    @Override
    Mono<SiteInner> updateInner(SitePatchResourceInner siteUpdate) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), siteUpdate);
    }

    @Override
    Mono<SiteInner> getInner() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name());
    }

    @Override
    Mono<SiteConfigResourceInner> getConfigInner() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getConfigurationSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name());
    }

    @Override
    Mono<SiteConfigResourceInner> createOrUpdateSiteConfig(SiteConfigResourceInner siteConfig) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createOrUpdateConfigurationSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), siteConfig);
    }

    @Override
    Mono<Void> deleteHostnameBinding(String hostname) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().deleteHostnameBindingSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), hostname);
    }

    @Override
    Mono<StringDictionaryInner> listAppSettings() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listApplicationSettingsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name());
    }

    @Override
    Mono<StringDictionaryInner> updateAppSettings(StringDictionaryInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateApplicationSettingsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), inner);
    }

    @Override
    Mono<ConnectionStringDictionaryInner> listConnectionStrings() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listConnectionStringsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name());
    }

    @Override
    Mono<ConnectionStringDictionaryInner> updateConnectionStrings(ConnectionStringDictionaryInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateConnectionStringsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), inner);
    }

    @Override
    Mono<SlotConfigNamesResourceInner> listSlotConfigurations() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listSlotConfigurationNamesAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name());
    }

    @Override
    Mono<SlotConfigNamesResourceInner> updateSlotConfigurations(SlotConfigNamesResourceInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateSlotConfigurationNamesAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), inner);
    }

    @Override
    Mono<SiteSourceControlInner> createOrUpdateSourceControl(SiteSourceControlInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createOrUpdateSourceControlSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), inner);
    }

    @Override
    public void swap(String slotName) {
        this.swapAsync(slotName).block();
    }

    @Override
    public Mono<Void> swapAsync(String slotName) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().swapSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), new CsmSlotEntity().withTargetSlot(slotName)).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void applySlotConfigurations(String slotName) {
        this.applySlotConfigurationsAsync(slotName).block();
    }

    @Override
    public Mono<Void> applySlotConfigurationsAsync(String slotName) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().applySlotConfigurationSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), new CsmSlotEntity().withTargetSlot(slotName)).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    public void resetSlotConfigurations() {
        this.resetSlotConfigurationsAsync().block();
    }

    @Override
    public Mono<Void> resetSlotConfigurationsAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().resetSlotConfigurationSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    Mono<Void> deleteSourceControl() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().deleteSourceControlSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()).then(this.refreshAsync()).then(Mono.empty());
    }

    @Override
    Mono<SiteAuthSettingsInner> updateAuthentication(SiteAuthSettingsInner inner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateAuthSettingsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), inner);
    }

    @Override
    Mono<SiteAuthSettingsInner> getAuthentication() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getAuthSettingsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name());
    }

    @Override
    Mono<MSDeployStatusInner> createMSDeploy(MSDeploy msDeployInner) {
        return ((WebSiteManagementClient)((AppServiceManager)((GroupableResourceImpl)this.parent()).manager()).serviceClient()).getWebApps().createMSDeployOperationAsync(((GroupableResourceImpl)this.parent()).resourceGroupName(), ((ResourceImpl)this.parent()).name(), msDeployInner);
    }

    @Override
    public WebAppSourceControl getSourceControl() {
        return this.getSourceControlAsync().block();
    }

    @Override
    public Mono<WebAppSourceControl> getSourceControlAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getSourceControlSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()).map(siteSourceControlInner -> new WebAppSourceControlImpl((SiteSourceControlInner)siteSourceControlInner, this));
    }

    @Override
    public byte[] getContainerLogs() {
        return this.getContainerLogsAsync().block();
    }

    @Override
    public Mono<byte[]> getContainerLogsAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getWebSiteContainerLogsSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()).map(BinaryData::toBytes);
    }

    @Override
    public byte[] getContainerLogsZip() {
        return this.getContainerLogsZipAsync().block();
    }

    @Override
    public Mono<byte[]> getContainerLogsZipAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().getContainerLogsZipSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name()).map(BinaryData::toBytes);
    }

    @Override
    Mono<SiteLogsConfigInner> updateDiagnosticLogsConfig(SiteLogsConfigInner siteLogsConfigInner) {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().updateDiagnosticLogsConfigSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), siteLogsConfigInner);
    }

    @Override
    public void verifyDomainOwnership(String certificateOrderName, String domainVerificationToken) {
        this.verifyDomainOwnershipAsync(certificateOrderName, domainVerificationToken).block();
    }

    @Override
    public Mono<Void> verifyDomainOwnershipAsync(String certificateOrderName, String domainVerificationToken) {
        IdentifierInner identifierInner = new IdentifierInner().withValue(domainVerificationToken);
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().createOrUpdateDomainOwnershipIdentifierSlotAsync(this.resourceGroupName(), ((ResourceImpl)this.parent()).name(), this.name(), certificateOrderName, identifierInner).then(Mono.empty());
    }

    public FluentImplT withRuntime(String runtime) {
        return (FluentImplT)((DeploymentSlotBaseImpl)this.withAppSetting("FUNCTIONS_WORKER_RUNTIME", runtime));
    }

    public FluentImplT withRuntimeVersion(String version) {
        return (FluentImplT)((DeploymentSlotBaseImpl)this.withAppSetting("FUNCTIONS_EXTENSION_VERSION", version.startsWith("~") ? version : "~" + version));
    }

    public FluentImplT withLatestRuntimeVersion() {
        return (FluentImplT)this.withRuntimeVersion("latest");
    }

    public FluentImplT withPublicDockerHubImage(String imageAndTag) {
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.setAppFrameworkVersion(String.format("DOCKER|%s", imageAndTag));
        return (FluentImplT)((DeploymentSlotBaseImpl)this.withAppSetting("DOCKER_CUSTOM_IMAGE_NAME", imageAndTag));
    }

    public FluentImplT withPrivateDockerHubImage(String imageAndTag) {
        return (FluentImplT)this.withPublicDockerHubImage(imageAndTag);
    }

    public FluentImplT withPrivateRegistryImage(String imageAndTag, String serverUrl) {
        imageAndTag = Utils.smartCompletionPrivateRegistryImage(imageAndTag, serverUrl);
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.setAppFrameworkVersion(String.format("DOCKER|%s", imageAndTag));
        this.withAppSetting("DOCKER_CUSTOM_IMAGE_NAME", imageAndTag);
        return (FluentImplT)((DeploymentSlotBaseImpl)this.withAppSetting("DOCKER_REGISTRY_SERVER_URL", serverUrl));
    }

    public FluentImplT withCredentials(String username, String password) {
        this.withAppSetting("DOCKER_REGISTRY_SERVER_USERNAME", username);
        return (FluentImplT)((DeploymentSlotBaseImpl)this.withAppSetting("DOCKER_REGISTRY_SERVER_PASSWORD", password));
    }

    public FluentImplT withStartUpCommand(String startUpCommand) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withAppCommandLine(startUpCommand);
        return (FluentImplT)this;
    }

    protected void cleanUpContainerSettings() {
        if (this.siteConfig != null && this.siteConfig.linuxFxVersion() != null) {
            this.siteConfig.withLinuxFxVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.windowsFxVersion() != null) {
            this.siteConfig.withWindowsFxVersion(null);
        }
        this.withoutAppSetting("DOCKER_CUSTOM_IMAGE_NAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_URL");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_USERNAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_PASSWORD");
    }
}

