/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.WorkflowsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RegenerateActionParameter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Workflow;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class WorkflowsClientImpl
implements WorkflowsClient {
    private final WorkflowsService service;
    private final WebSiteManagementClientImpl client;

    WorkflowsClientImpl(WebSiteManagementClientImpl client) {
        this.service = RestProxy.create(WorkflowsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> regenerateAccessKeyWithResponseAsync(String resourceGroupName, String name, String workflowName, RegenerateActionParameter keyType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (keyType == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyType is required and cannot be null."));
        }
        keyType.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateAccessKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, this.client.getApiVersion(), keyType, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> regenerateAccessKeyWithResponseAsync(String resourceGroupName, String name, String workflowName, RegenerateActionParameter keyType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (keyType == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyType is required and cannot be null."));
        }
        keyType.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerateAccessKey(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, this.client.getApiVersion(), keyType, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> regenerateAccessKeyAsync(String resourceGroupName, String name, String workflowName, RegenerateActionParameter keyType) {
        return this.regenerateAccessKeyWithResponseAsync(resourceGroupName, name, workflowName, keyType).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> regenerateAccessKeyWithResponse(String resourceGroupName, String name, String workflowName, RegenerateActionParameter keyType, Context context) {
        return this.regenerateAccessKeyWithResponseAsync(resourceGroupName, name, workflowName, keyType, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void regenerateAccessKey(String resourceGroupName, String name, String workflowName, RegenerateActionParameter keyType) {
        this.regenerateAccessKeyWithResponse(resourceGroupName, name, workflowName, keyType, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> validateWithResponseAsync(String resourceGroupName, String name, String workflowName, Workflow validate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (validate == null) {
            return Mono.error(new IllegalArgumentException("Parameter validate is required and cannot be null."));
        }
        validate.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, this.client.getApiVersion(), validate, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> validateWithResponseAsync(String resourceGroupName, String name, String workflowName, Workflow validate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error(new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (validate == null) {
            return Mono.error(new IllegalArgumentException("Parameter validate is required and cannot be null."));
        }
        validate.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, name, workflowName, this.client.getApiVersion(), validate, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validateAsync(String resourceGroupName, String name, String workflowName, Workflow validate) {
        return this.validateWithResponseAsync(resourceGroupName, name, workflowName, validate).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> validateWithResponse(String resourceGroupName, String name, String workflowName, Workflow validate, Context context) {
        return this.validateWithResponseAsync(resourceGroupName, name, workflowName, validate, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validate(String resourceGroupName, String name, String workflowName, Workflow validate) {
        this.validateWithResponse(resourceGroupName, name, workflowName, validate, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    public static interface WorkflowsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/regenerateAccessKey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> regenerateAccessKey(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") RegenerateActionParameter var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostruntime/runtime/webhooks/workflow/api/management/workflows/{workflowName}/validate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> validate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="name") String var4, @PathParam(value="workflowName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") Workflow var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

