/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.DetectorDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DiagnosticMetricSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.NameValuePair;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ResponseMetadata;
import java.io.IOException;
import java.util.List;

public final class AnalysisData
implements JsonSerializable<AnalysisData> {
    private String source;
    private DetectorDefinition detectorDefinition;
    private List<DiagnosticMetricSet> metrics;
    private List<List<NameValuePair>> data;
    private ResponseMetadata detectorMetadata;

    public String source() {
        return this.source;
    }

    public AnalysisData withSource(String source2) {
        this.source = source2;
        return this;
    }

    public DetectorDefinition detectorDefinition() {
        return this.detectorDefinition;
    }

    public AnalysisData withDetectorDefinition(DetectorDefinition detectorDefinition) {
        this.detectorDefinition = detectorDefinition;
        return this;
    }

    public List<DiagnosticMetricSet> metrics() {
        return this.metrics;
    }

    public AnalysisData withMetrics(List<DiagnosticMetricSet> metrics) {
        this.metrics = metrics;
        return this;
    }

    public List<List<NameValuePair>> data() {
        return this.data;
    }

    public AnalysisData withData(List<List<NameValuePair>> data) {
        this.data = data;
        return this;
    }

    public ResponseMetadata detectorMetadata() {
        return this.detectorMetadata;
    }

    public AnalysisData withDetectorMetadata(ResponseMetadata detectorMetadata) {
        this.detectorMetadata = detectorMetadata;
        return this;
    }

    public void validate() {
        if (this.detectorDefinition() != null) {
            this.detectorDefinition().validate();
        }
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
        if (this.data() != null) {
            this.data().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (this.detectorMetadata() != null) {
            this.detectorMetadata().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeJsonField("detectorDefinition", this.detectorDefinition);
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeJson((JsonSerializable<?>)element1)));
        jsonWriter.writeJsonField("detectorMetaData", this.detectorMetadata);
        return jsonWriter.writeEndObject();
    }

    public static AnalysisData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AnalysisData deserializedAnalysisData = new AnalysisData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedAnalysisData.source = reader.getString();
                    continue;
                }
                if ("detectorDefinition".equals(fieldName)) {
                    deserializedAnalysisData.detectorDefinition = DetectorDefinition.fromJson(reader);
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    List<DiagnosticMetricSet> metrics = reader.readArray(reader1 -> DiagnosticMetricSet.fromJson(reader1));
                    deserializedAnalysisData.metrics = metrics;
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List<List> data = reader.readArray(reader1 -> reader1.readArray(reader2 -> NameValuePair.fromJson(reader2)));
                    deserializedAnalysisData.data = data;
                    continue;
                }
                if ("detectorMetaData".equals(fieldName)) {
                    deserializedAnalysisData.detectorMetadata = ResponseMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalysisData;
        });
    }
}

