/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.DaprLogLevel;
import java.io.IOException;

public final class DaprConfig
implements JsonSerializable<DaprConfig> {
    private Boolean enabled;
    private String appId;
    private Integer appPort;
    private Integer httpReadBufferSize;
    private Integer httpMaxRequestSize;
    private DaprLogLevel logLevel;
    private Boolean enableApiLogging;

    public Boolean enabled() {
        return this.enabled;
    }

    public DaprConfig withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String appId() {
        return this.appId;
    }

    public DaprConfig withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public Integer appPort() {
        return this.appPort;
    }

    public DaprConfig withAppPort(Integer appPort) {
        this.appPort = appPort;
        return this;
    }

    public Integer httpReadBufferSize() {
        return this.httpReadBufferSize;
    }

    public DaprConfig withHttpReadBufferSize(Integer httpReadBufferSize) {
        this.httpReadBufferSize = httpReadBufferSize;
        return this;
    }

    public Integer httpMaxRequestSize() {
        return this.httpMaxRequestSize;
    }

    public DaprConfig withHttpMaxRequestSize(Integer httpMaxRequestSize) {
        this.httpMaxRequestSize = httpMaxRequestSize;
        return this;
    }

    public DaprLogLevel logLevel() {
        return this.logLevel;
    }

    public DaprConfig withLogLevel(DaprLogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public Boolean enableApiLogging() {
        return this.enableApiLogging;
    }

    public DaprConfig withEnableApiLogging(Boolean enableApiLogging) {
        this.enableApiLogging = enableApiLogging;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("appId", this.appId);
        jsonWriter.writeNumberField("appPort", this.appPort);
        jsonWriter.writeNumberField("httpReadBufferSize", this.httpReadBufferSize);
        jsonWriter.writeNumberField("httpMaxRequestSize", this.httpMaxRequestSize);
        jsonWriter.writeStringField("logLevel", this.logLevel == null ? null : this.logLevel.toString());
        jsonWriter.writeBooleanField("enableApiLogging", this.enableApiLogging);
        return jsonWriter.writeEndObject();
    }

    public static DaprConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprConfig deserializedDaprConfig = new DaprConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedDaprConfig.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appId".equals(fieldName)) {
                    deserializedDaprConfig.appId = reader.getString();
                    continue;
                }
                if ("appPort".equals(fieldName)) {
                    deserializedDaprConfig.appPort = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("httpReadBufferSize".equals(fieldName)) {
                    deserializedDaprConfig.httpReadBufferSize = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("httpMaxRequestSize".equals(fieldName)) {
                    deserializedDaprConfig.httpMaxRequestSize = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("logLevel".equals(fieldName)) {
                    deserializedDaprConfig.logLevel = DaprLogLevel.fromString(reader.getString());
                    continue;
                }
                if ("enableApiLogging".equals(fieldName)) {
                    deserializedDaprConfig.enableApiLogging = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprConfig;
        });
    }
}

