/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ErrorEntity
implements JsonSerializable<ErrorEntity> {
    private String extendedCode;
    private String messageTemplate;
    private List<String> parameters;
    private List<ErrorEntity> innerErrors;
    private List<ErrorEntity> details;
    private String target;
    private String code;
    private String message;

    public String extendedCode() {
        return this.extendedCode;
    }

    public ErrorEntity withExtendedCode(String extendedCode) {
        this.extendedCode = extendedCode;
        return this;
    }

    public String messageTemplate() {
        return this.messageTemplate;
    }

    public ErrorEntity withMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
        return this;
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public ErrorEntity withParameters(List<String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<ErrorEntity> innerErrors() {
        return this.innerErrors;
    }

    public ErrorEntity withInnerErrors(List<ErrorEntity> innerErrors) {
        this.innerErrors = innerErrors;
        return this;
    }

    public List<ErrorEntity> details() {
        return this.details;
    }

    public ErrorEntity withDetails(List<ErrorEntity> details) {
        this.details = details;
        return this;
    }

    public String target() {
        return this.target;
    }

    public ErrorEntity withTarget(String target) {
        this.target = target;
        return this;
    }

    public String code() {
        return this.code;
    }

    public ErrorEntity withCode(String code) {
        this.code = code;
        return this;
    }

    public String message() {
        return this.message;
    }

    public ErrorEntity withMessage(String message) {
        this.message = message;
        return this;
    }

    public void validate() {
        if (this.innerErrors() != null) {
            this.innerErrors().forEach(e -> e.validate());
        }
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("extendedCode", this.extendedCode);
        jsonWriter.writeStringField("messageTemplate", this.messageTemplate);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("innerErrors", this.innerErrors, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static ErrorEntity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ErrorEntity deserializedErrorEntity = new ErrorEntity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extendedCode".equals(fieldName)) {
                    deserializedErrorEntity.extendedCode = reader.getString();
                    continue;
                }
                if ("messageTemplate".equals(fieldName)) {
                    deserializedErrorEntity.messageTemplate = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List<String> parameters = reader.readArray(reader1 -> reader1.getString());
                    deserializedErrorEntity.parameters = parameters;
                    continue;
                }
                if ("innerErrors".equals(fieldName)) {
                    List<ErrorEntity> innerErrors = reader.readArray(reader1 -> ErrorEntity.fromJson(reader1));
                    deserializedErrorEntity.innerErrors = innerErrors;
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List<ErrorEntity> details = reader.readArray(reader1 -> ErrorEntity.fromJson(reader1));
                    deserializedErrorEntity.details = details;
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedErrorEntity.target = reader.getString();
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedErrorEntity.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedErrorEntity.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedErrorEntity;
        });
    }
}

