/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChangeTrackedEntity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShiftAvailability;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphShiftPreferences
extends MicrosoftGraphChangeTrackedEntity {
    private List<MicrosoftGraphShiftAvailability> availability;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphShiftAvailability> availability() {
        return this.availability;
    }

    public MicrosoftGraphShiftPreferences withAvailability(List<MicrosoftGraphShiftAvailability> availability) {
        this.availability = availability;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphShiftPreferences withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphShiftPreferences withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphShiftPreferences withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphShiftPreferences withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphShiftPreferences withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.availability() != null) {
            this.availability().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeArrayField("availability", this.availability, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphShiftPreferences fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphShiftPreferences deserializedMicrosoftGraphShiftPreferences = new MicrosoftGraphShiftPreferences();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftPreferences.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftPreferences.withCreatedDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftPreferences.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftPreferences.withLastModifiedDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("availability".equals(fieldName)) {
                    List<MicrosoftGraphShiftAvailability> availability = reader.readArray(reader1 -> MicrosoftGraphShiftAvailability.fromJson(reader1));
                    deserializedMicrosoftGraphShiftPreferences.availability = availability;
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphShiftPreferences.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphShiftPreferences;
        });
    }
}

