/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.PermissionInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RoleDefinitionProperties
implements JsonSerializable<RoleDefinitionProperties> {
    private String roleName;
    private String description;
    private String roleType;
    private List<PermissionInner> permissions;
    private List<String> assignableScopes;
    private OffsetDateTime createdOn;
    private OffsetDateTime updatedOn;
    private String createdBy;
    private String updatedBy;

    public String roleName() {
        return this.roleName;
    }

    public RoleDefinitionProperties withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RoleDefinitionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String roleType() {
        return this.roleType;
    }

    public RoleDefinitionProperties withRoleType(String roleType) {
        this.roleType = roleType;
        return this;
    }

    public List<PermissionInner> permissions() {
        return this.permissions;
    }

    public RoleDefinitionProperties withPermissions(List<PermissionInner> permissions) {
        this.permissions = permissions;
        return this;
    }

    public List<String> assignableScopes() {
        return this.assignableScopes;
    }

    public RoleDefinitionProperties withAssignableScopes(List<String> assignableScopes) {
        this.assignableScopes = assignableScopes;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public OffsetDateTime updatedOn() {
        return this.updatedOn;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public String updatedBy() {
        return this.updatedBy;
    }

    public void validate() {
        if (this.permissions() != null) {
            this.permissions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleName", this.roleName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.roleType);
        jsonWriter.writeArrayField("permissions", this.permissions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("assignableScopes", this.assignableScopes, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static RoleDefinitionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleDefinitionProperties deserializedRoleDefinitionProperties = new RoleDefinitionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleName".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.roleName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.description = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.roleType = reader.getString();
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    List<PermissionInner> permissions = reader.readArray(reader1 -> PermissionInner.fromJson(reader1));
                    deserializedRoleDefinitionProperties.permissions = permissions;
                    continue;
                }
                if ("assignableScopes".equals(fieldName)) {
                    List<String> assignableScopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedRoleDefinitionProperties.assignableScopes = assignableScopes;
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.createdOn = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("updatedOn".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.updatedOn = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.createdBy = reader.getString();
                    continue;
                }
                if ("updatedBy".equals(fieldName)) {
                    deserializedRoleDefinitionProperties.updatedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleDefinitionProperties;
        });
    }
}

