/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.util.retry.Retry;
import com.dataiku.dss.shadelibazure.reactor.util.retry.RetryBackoffSpec;
import java.time.Duration;

class RetryUtils {
    RetryUtils() {
    }

    static RetryBackoffSpec backoffRetryFor404ResourceNotFound() {
        return RetryUtils.backoffRetry(404, "Request_ResourceNotFound");
    }

    static RetryBackoffSpec backoffRetryFor400BadRequest() {
        return RetryUtils.backoffRetry(400, "Request_BadRequest");
    }

    static RetryBackoffSpec backoffRetryFor400PrincipalNotFound() {
        return RetryUtils.backoffRetry(400, "PrincipalNotFound");
    }

    private static RetryBackoffSpec backoffRetry(int statusCode, String errorCode) {
        return Retry.backoff(3L, ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(Duration.ofSeconds(10L))).filter(throwable -> {
            ManagementException exception;
            boolean resourceNotFoundException = false;
            if (throwable instanceof ManagementException && (exception = (ManagementException)throwable).getResponse().getStatusCode() == statusCode && exception.getValue() != null && errorCode.equalsIgnoreCase(exception.getValue().getCode())) {
                resourceNotFoundException = true;
            }
            return resourceNotFoundException;
        }).onRetryExhaustedThrow((spec, signal) -> signal.failure());
    }
}

