/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.RetryUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryUser;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.RoleAssignmentCreateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceGroup;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class RoleAssignmentImpl
extends CreatableImpl<RoleAssignment, RoleAssignmentInner, RoleAssignmentImpl>
implements RoleAssignment,
RoleAssignment.Definition {
    private AuthorizationManager manager;
    private String objectId;
    private String userName;
    private String servicePrincipalName;
    private String roleDefinitionId;
    private String roleName;
    private String scope;
    private String description;
    private final ClientLogger logger = new ClientLogger(RoleAssignmentImpl.class);

    RoleAssignmentImpl(String name, RoleAssignmentInner innerObject, AuthorizationManager manager) {
        super(name, innerObject);
        this.manager = manager;
    }

    @Override
    public boolean isInCreateMode() {
        return ((RoleAssignmentInner)this.innerModel()).id() == null;
    }

    @Override
    public Mono<RoleAssignment> createResourceAsync() {
        Mono<String> roleDefinitionIdObservable;
        Mono<String> objectIdObservable;
        if (this.objectId != null) {
            objectIdObservable = Mono.just(this.objectId);
        } else if (this.userName != null) {
            objectIdObservable = this.manager.users().getByNameAsync(this.userName).map(user -> user.id());
        } else if (this.servicePrincipalName != null) {
            objectIdObservable = this.manager.servicePrincipals().getByNameAsync(this.servicePrincipalName).map(sp -> sp.id());
        } else {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Please pass a non-null value for either object Id, user, group, or service principal"));
        }
        if (this.roleDefinitionId != null) {
            roleDefinitionIdObservable = Mono.just(this.roleDefinitionId);
        } else if (this.roleName != null) {
            roleDefinitionIdObservable = this.manager().roleDefinitions().getByScopeAndRoleNameAsync(this.scope(), this.roleName).map(roleDefinition -> roleDefinition.id());
        } else {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Please pass a non-null value for either role name or role definition ID"));
        }
        return Mono.zip(objectIdObservable, roleDefinitionIdObservable, (objectId, roleDefinitionId) -> new RoleAssignmentCreateParameters().withPrincipalId((String)objectId).withRoleDefinitionId((String)roleDefinitionId).withDescription(this.description)).flatMap(roleAssignmentPropertiesInner -> this.manager().roleServiceClient().getRoleAssignments().createAsync(this.scope(), this.name(), (RoleAssignmentCreateParameters)roleAssignmentPropertiesInner).retryWhen(RetryUtils.backoffRetryFor400PrincipalNotFound())).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<RoleAssignmentInner> getInnerAsync() {
        return this.manager.roleServiceClient().getRoleAssignments().getAsync(this.scope(), this.name());
    }

    @Override
    public String scope() {
        return this.scope == null ? ((RoleAssignmentInner)this.innerModel()).scope() : this.scope;
    }

    @Override
    public String roleDefinitionId() {
        return ((RoleAssignmentInner)this.innerModel()).roleDefinitionId();
    }

    @Override
    public String principalId() {
        return ((RoleAssignmentInner)this.innerModel()).principalId();
    }

    @Override
    public String condition() {
        return ((RoleAssignmentInner)this.innerModel()).condition();
    }

    @Override
    public String description() {
        return ((RoleAssignmentInner)this.innerModel()).description();
    }

    @Override
    public RoleAssignmentImpl forObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    @Override
    public RoleAssignmentImpl forUser(ActiveDirectoryUser user) {
        this.objectId = user.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forUser(String name) {
        this.userName = name;
        return this;
    }

    @Override
    public RoleAssignmentImpl forGroup(ActiveDirectoryGroup activeDirectoryGroup) {
        this.objectId = activeDirectoryGroup.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forServicePrincipal(ServicePrincipal servicePrincipal) {
        this.objectId = servicePrincipal.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forServicePrincipal(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
        return this;
    }

    @Override
    public RoleAssignmentImpl withBuiltInRole(BuiltInRole role) {
        this.roleName = role.toString();
        return this;
    }

    @Override
    public RoleAssignmentImpl withRoleDefinition(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    @Override
    public RoleAssignmentImpl withScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public RoleAssignmentImpl withResourceGroupScope(ResourceGroup resourceGroup) {
        return this.withScope(resourceGroup.id());
    }

    @Override
    public RoleAssignmentImpl withResourceScope(Resource resource) {
        return this.withScope(resource.id());
    }

    @Override
    public RoleAssignmentImpl withSubscriptionScope(String subscriptionId) {
        return this.withScope("/subscriptions/" + subscriptionId);
    }

    @Override
    public RoleAssignmentImpl withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String id() {
        return ((RoleAssignmentInner)this.innerModel()).id();
    }

    @Override
    public AuthorizationManager manager() {
        return this.manager;
    }
}

