/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models.EndpointPropertiesUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.DeepCreatedCustomDomain;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.DeepCreatedOrigin;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.DeepCreatedOriginGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.EndpointProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.EndpointResourceState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.GeoFilter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.OptimizationType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.UrlSigningKey;
import java.io.IOException;
import java.util.List;

public final class EndpointProperties
extends EndpointPropertiesUpdateParameters {
    private String hostname;
    private List<DeepCreatedOrigin> origins;
    private List<DeepCreatedOriginGroup> originGroups;
    private List<DeepCreatedCustomDomain> customDomains;
    private EndpointResourceState resourceState;
    private EndpointProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(EndpointProperties.class);

    public String hostname() {
        return this.hostname;
    }

    public List<DeepCreatedOrigin> origins() {
        return this.origins;
    }

    public EndpointProperties withOrigins(List<DeepCreatedOrigin> origins) {
        this.origins = origins;
        return this;
    }

    public List<DeepCreatedOriginGroup> originGroups() {
        return this.originGroups;
    }

    public EndpointProperties withOriginGroups(List<DeepCreatedOriginGroup> originGroups) {
        this.originGroups = originGroups;
        return this;
    }

    public List<DeepCreatedCustomDomain> customDomains() {
        return this.customDomains;
    }

    public EndpointResourceState resourceState() {
        return this.resourceState;
    }

    public EndpointProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public EndpointProperties withOriginPath(String originPath) {
        super.withOriginPath(originPath);
        return this;
    }

    @Override
    public EndpointProperties withContentTypesToCompress(List<String> contentTypesToCompress) {
        super.withContentTypesToCompress(contentTypesToCompress);
        return this;
    }

    @Override
    public EndpointProperties withOriginHostHeader(String originHostHeader) {
        super.withOriginHostHeader(originHostHeader);
        return this;
    }

    @Override
    public EndpointProperties withIsCompressionEnabled(Boolean isCompressionEnabled) {
        super.withIsCompressionEnabled(isCompressionEnabled);
        return this;
    }

    @Override
    public EndpointProperties withIsHttpAllowed(Boolean isHttpAllowed) {
        super.withIsHttpAllowed(isHttpAllowed);
        return this;
    }

    @Override
    public EndpointProperties withIsHttpsAllowed(Boolean isHttpsAllowed) {
        super.withIsHttpsAllowed(isHttpsAllowed);
        return this;
    }

    @Override
    public EndpointProperties withQueryStringCachingBehavior(QueryStringCachingBehavior queryStringCachingBehavior) {
        super.withQueryStringCachingBehavior(queryStringCachingBehavior);
        return this;
    }

    @Override
    public EndpointProperties withOptimizationType(OptimizationType optimizationType) {
        super.withOptimizationType(optimizationType);
        return this;
    }

    @Override
    public EndpointProperties withProbePath(String probePath) {
        super.withProbePath(probePath);
        return this;
    }

    @Override
    public EndpointProperties withGeoFilters(List<GeoFilter> geoFilters) {
        super.withGeoFilters(geoFilters);
        return this;
    }

    @Override
    public EndpointProperties withDefaultOriginGroup(ResourceReference defaultOriginGroup) {
        super.withDefaultOriginGroup(defaultOriginGroup);
        return this;
    }

    @Override
    public EndpointProperties withUrlSigningKeys(List<UrlSigningKey> urlSigningKeys) {
        super.withUrlSigningKeys(urlSigningKeys);
        return this;
    }

    @Override
    public EndpointProperties withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy) {
        super.withDeliveryPolicy(deliveryPolicy);
        return this;
    }

    @Override
    public EndpointProperties withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        super.withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.origins() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property origins in model EndpointProperties"));
        }
        this.origins().forEach(e -> e.validate());
        if (this.originGroups() != null) {
            this.originGroups().forEach(e -> e.validate());
        }
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("originPath", this.originPath());
        jsonWriter.writeArrayField("contentTypesToCompress", this.contentTypesToCompress(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("originHostHeader", this.originHostHeader());
        jsonWriter.writeBooleanField("isCompressionEnabled", this.isCompressionEnabled());
        jsonWriter.writeBooleanField("isHttpAllowed", this.isHttpAllowed());
        jsonWriter.writeBooleanField("isHttpsAllowed", this.isHttpsAllowed());
        jsonWriter.writeStringField("queryStringCachingBehavior", this.queryStringCachingBehavior() == null ? null : this.queryStringCachingBehavior().toString());
        jsonWriter.writeStringField("optimizationType", this.optimizationType() == null ? null : this.optimizationType().toString());
        jsonWriter.writeStringField("probePath", this.probePath());
        jsonWriter.writeArrayField("geoFilters", this.geoFilters(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("defaultOriginGroup", this.defaultOriginGroup());
        jsonWriter.writeArrayField("urlSigningKeys", this.urlSigningKeys(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("deliveryPolicy", this.deliveryPolicy());
        jsonWriter.writeJsonField("webApplicationFirewallPolicyLink", this.webApplicationFirewallPolicyLink());
        jsonWriter.writeArrayField("origins", this.origins, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("originGroups", this.originGroups, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static EndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EndpointProperties deserializedEndpointProperties = new EndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("originPath".equals(fieldName)) {
                    deserializedEndpointProperties.withOriginPath(reader.getString());
                    continue;
                }
                if ("contentTypesToCompress".equals(fieldName)) {
                    List<String> contentTypesToCompress = reader.readArray(reader1 -> reader1.getString());
                    deserializedEndpointProperties.withContentTypesToCompress((List)contentTypesToCompress);
                    continue;
                }
                if ("originHostHeader".equals(fieldName)) {
                    deserializedEndpointProperties.withOriginHostHeader(reader.getString());
                    continue;
                }
                if ("isCompressionEnabled".equals(fieldName)) {
                    deserializedEndpointProperties.withIsCompressionEnabled(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isHttpAllowed".equals(fieldName)) {
                    deserializedEndpointProperties.withIsHttpAllowed(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isHttpsAllowed".equals(fieldName)) {
                    deserializedEndpointProperties.withIsHttpsAllowed(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("queryStringCachingBehavior".equals(fieldName)) {
                    deserializedEndpointProperties.withQueryStringCachingBehavior(QueryStringCachingBehavior.fromString(reader.getString()));
                    continue;
                }
                if ("optimizationType".equals(fieldName)) {
                    deserializedEndpointProperties.withOptimizationType(OptimizationType.fromString(reader.getString()));
                    continue;
                }
                if ("probePath".equals(fieldName)) {
                    deserializedEndpointProperties.withProbePath(reader.getString());
                    continue;
                }
                if ("geoFilters".equals(fieldName)) {
                    List<GeoFilter> geoFilters = reader.readArray(reader1 -> GeoFilter.fromJson(reader1));
                    deserializedEndpointProperties.withGeoFilters((List)geoFilters);
                    continue;
                }
                if ("defaultOriginGroup".equals(fieldName)) {
                    deserializedEndpointProperties.withDefaultOriginGroup(ResourceReference.fromJson(reader));
                    continue;
                }
                if ("urlSigningKeys".equals(fieldName)) {
                    List<UrlSigningKey> urlSigningKeys = reader.readArray(reader1 -> UrlSigningKey.fromJson(reader1));
                    deserializedEndpointProperties.withUrlSigningKeys((List)urlSigningKeys);
                    continue;
                }
                if ("deliveryPolicy".equals(fieldName)) {
                    deserializedEndpointProperties.withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy.fromJson(reader));
                    continue;
                }
                if ("webApplicationFirewallPolicyLink".equals(fieldName)) {
                    deserializedEndpointProperties.withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink.fromJson(reader));
                    continue;
                }
                if ("origins".equals(fieldName)) {
                    List<DeepCreatedOrigin> origins = reader.readArray(reader1 -> DeepCreatedOrigin.fromJson(reader1));
                    deserializedEndpointProperties.origins = origins;
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedEndpointProperties.hostname = reader.getString();
                    continue;
                }
                if ("originGroups".equals(fieldName)) {
                    List<DeepCreatedOriginGroup> originGroups = reader.readArray(reader1 -> DeepCreatedOriginGroup.fromJson(reader1));
                    deserializedEndpointProperties.originGroups = originGroups;
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List<DeepCreatedCustomDomain> customDomains = reader.readArray(reader1 -> DeepCreatedCustomDomain.fromJson(reader1));
                    deserializedEndpointProperties.customDomains = customDomains;
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedEndpointProperties.resourceState = EndpointResourceState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedEndpointProperties.provisioningState = EndpointProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointProperties;
        });
    }
}

