/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.CdnManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.CdnManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models.ProfileInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.fluent.models.SsoUriInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.implementation.CdnEndpointImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.implementation.CdnEndpointsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CdnEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CdnProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CheckNameAvailabilityResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.CustomDomainValidationResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.LoadParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ProfileUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.PurgeParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceUsage;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ValidateCustomDomainInput;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

class CdnProfileImpl
extends GroupableResourceImpl<CdnProfile, ProfileInner, CdnProfileImpl, CdnManager>
implements CdnProfile,
CdnProfile.Definition,
CdnProfile.Update {
    private CdnEndpointsImpl endpoints = new CdnEndpointsImpl(this);

    CdnProfileImpl(String name, ProfileInner innerModel, CdnManager cdnManager) {
        super(name, innerModel, cdnManager);
    }

    @Override
    public Map<String, CdnEndpoint> endpoints() {
        return this.endpoints.endpointsAsMap();
    }

    @Override
    public String generateSsoUri() {
        return this.generateSsoUriAsync().block();
    }

    @Override
    public Mono<String> generateSsoUriAsync() {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().generateSsoUriAsync(this.resourceGroupName(), this.name()).map(SsoUriInner::ssoUriValue);
    }

    @Override
    public void startEndpoint(String endpointName) {
        this.startEndpointAsync(endpointName).block();
    }

    @Override
    public Mono<Void> startEndpointAsync(String endpointName) {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().startAsync(this.resourceGroupName(), this.name(), endpointName).then();
    }

    @Override
    public void stopEndpoint(String endpointName) {
        this.stopEndpointAsync(endpointName).block();
    }

    @Override
    public Mono<Void> stopEndpointAsync(String endpointName) {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().stopAsync(this.resourceGroupName(), this.name(), endpointName).then();
    }

    @Override
    public PagedIterable<ResourceUsage> listResourceUsage() {
        return PagedConverter.mapPage(((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().listResourceUsage(this.resourceGroupName(), this.name()), ResourceUsage::new);
    }

    @Override
    public void purgeEndpointContent(String endpointName, Set<String> contentPaths) {
        this.purgeEndpointContentAsync(endpointName, contentPaths).block();
    }

    @Override
    public Mono<Void> purgeEndpointContentAsync(String endpointName, Set<String> contentPaths) {
        if (contentPaths != null) {
            return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().purgeContentAsync(this.resourceGroupName(), this.name(), endpointName, new PurgeParameters().withContentPaths(new ArrayList<String>(contentPaths)));
        }
        return Mono.empty();
    }

    @Override
    public void loadEndpointContent(String endpointName, Set<String> contentPaths) {
        this.loadEndpointContentAsync(endpointName, contentPaths).block();
    }

    @Override
    public Mono<Void> loadEndpointContentAsync(String endpointName, Set<String> contentPaths) {
        if (contentPaths != null) {
            return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().loadContentAsync(this.resourceGroupName(), this.name(), endpointName, new LoadParameters().withContentPaths(new ArrayList<String>(contentPaths)));
        }
        return Mono.empty();
    }

    @Override
    public CustomDomainValidationResult validateEndpointCustomDomain(String endpointName, String hostName) {
        return this.validateEndpointCustomDomainAsync(endpointName, hostName).block();
    }

    @Override
    public Mono<CustomDomainValidationResult> validateEndpointCustomDomainAsync(String endpointName, String hostName) {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getEndpoints().validateCustomDomainAsync(this.resourceGroupName(), this.name(), endpointName, new ValidateCustomDomainInput().withHostname(hostName)).map(CustomDomainValidationResult::new);
    }

    @Override
    public CheckNameAvailabilityResult checkEndpointNameAvailability(String name) {
        return this.checkEndpointNameAvailabilityAsync(name).block();
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String name) {
        return ((CdnManager)this.manager()).profiles().checkEndpointNameAvailabilityAsync(name);
    }

    @Override
    public boolean isPremiumVerizon() {
        return this.sku() != null && this.sku().name() != null && this.sku().name().equals(SkuName.PREMIUM_VERIZON);
    }

    @Override
    public String regionName() {
        return ((ProfileInner)this.innerModel()).location();
    }

    @Override
    public Sku sku() {
        return ((ProfileInner)this.innerModel()).sku();
    }

    @Override
    public String resourceState() {
        return ((ProfileInner)this.innerModel()).resourceState().toString();
    }

    @Override
    protected Mono<ProfileInner> getInnerAsync() {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<CdnProfile> createResourceAsync() {
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().createAsync(this.resourceGroupName(), this.name(), (ProfileInner)this.innerModel()).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<CdnProfile> updateResourceAsync() {
        CdnProfileImpl self = this;
        return ((CdnManagementClient)((CdnManager)this.manager()).serviceClient()).getProfiles().updateAsync(this.resourceGroupName(), this.name(), new ProfileUpdateParameters().withTags(((ProfileInner)this.innerModel()).tags())).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    @Override
    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        if (isGroupFaulted) {
            this.endpoints.clear();
            return Mono.empty();
        }
        return this.refreshAsync().then();
    }

    @Override
    public Mono<CdnProfile> refreshAsync() {
        return super.refreshAsync().map(cdnProfile -> {
            this.endpoints.clear();
            return cdnProfile;
        });
    }

    @Override
    public CdnProfileImpl withStandardAkamaiSku() {
        ((ProfileInner)this.innerModel()).withSku(new Sku().withName(SkuName.STANDARD_AKAMAI));
        return this;
    }

    @Override
    public CdnProfileImpl withStandardVerizonSku() {
        ((ProfileInner)this.innerModel()).withSku(new Sku().withName(SkuName.STANDARD_VERIZON));
        return this;
    }

    @Override
    public CdnProfileImpl withPremiumVerizonSku() {
        ((ProfileInner)this.innerModel()).withSku(new Sku().withName(SkuName.PREMIUM_VERIZON));
        return this;
    }

    @Override
    public CdnProfileImpl withStandardMicrosoftSku() {
        ((ProfileInner)this.innerModel()).withSku(new Sku().withName(SkuName.STANDARD_MICROSOFT));
        return this;
    }

    @Override
    public CdnProfileImpl withSku(SkuName skuName) {
        ((ProfileInner)this.innerModel()).withSku(new Sku().withName(skuName));
        return this;
    }

    @Override
    public CdnProfileImpl withNewEndpoint(String endpointOriginHostname) {
        CdnEndpointImpl endpoint = this.endpoints.defineNewEndpointWithOriginHostname(endpointOriginHostname);
        this.endpoints.addEndpoint(endpoint);
        return this;
    }

    public CdnEndpointImpl defineNewEndpoint() {
        return this.endpoints.defineNewEndpoint();
    }

    public CdnEndpointImpl defineNewEndpoint(String name) {
        return this.endpoints.defineNewEndpoint(name);
    }

    public CdnEndpointImpl defineNewEndpoint(String name, String endpointOriginHostname) {
        return this.endpoints.defineNewEndpoint(name, endpointOriginHostname);
    }

    @Override
    public CdnProfileImpl withNewPremiumEndpoint(String endpointOriginHostname) {
        return this.withNewEndpoint(endpointOriginHostname);
    }

    public CdnEndpointImpl defineNewPremiumEndpoint() {
        return this.endpoints.defineNewEndpoint();
    }

    public CdnEndpointImpl defineNewPremiumEndpoint(String name) {
        return this.defineNewEndpoint(name);
    }

    public CdnEndpointImpl defineNewPremiumEndpoint(String name, String endpointOriginHostname) {
        return this.defineNewEndpoint(name, endpointOriginHostname);
    }

    @Override
    public CdnEndpointImpl updateEndpoint(String name) {
        return this.endpoints.updateEndpoint(name);
    }

    @Override
    public CdnEndpointImpl updatePremiumEndpoint(String name) {
        return this.endpoints.updateEndpoint(name);
    }

    @Override
    public CdnProfile.Update withoutEndpoint(String name) {
        this.endpoints.remove(name);
        return this;
    }

    CdnProfileImpl withEndpoint(CdnEndpointImpl endpoint) {
        this.endpoints.addEndpoint(endpoint);
        return this;
    }
}

