/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ClientPortOperator;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class ClientPortMatchConditionParameters
implements JsonSerializable<ClientPortMatchConditionParameters> {
    private String typeName = "DeliveryRuleClientPortConditionParameters";
    private ClientPortOperator operator;
    private Boolean negateCondition;
    private List<String> matchValues;
    private List<Transform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(ClientPortMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public ClientPortMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public ClientPortOperator operator() {
        return this.operator;
    }

    public ClientPortMatchConditionParameters withOperator(ClientPortOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public ClientPortMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public ClientPortMatchConditionParameters withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public ClientPortMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property operator in model ClientPortMatchConditionParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static ClientPortMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientPortMatchConditionParameters deserializedClientPortMatchConditionParameters = new ClientPortMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedClientPortMatchConditionParameters.operator = ClientPortOperator.fromString(reader.getString());
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedClientPortMatchConditionParameters.negateCondition = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List<String> matchValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedClientPortMatchConditionParameters.matchValues = matchValues;
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List<Transform> transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    deserializedClientPortMatchConditionParameters.transforms = transforms;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientPortMatchConditionParameters;
        });
    }
}

