/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.Certificate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.SecretType;
import java.io.IOException;
import java.util.List;

public final class CustomerCertificate
extends Certificate {
    private ResourceReference secretSource;
    private String secretVersion;
    private String certificateAuthority;
    private Boolean useLatestVersion;
    private List<String> subjectAlternativeNames;
    private String thumbprint;
    private String expirationDate;
    private String subject;

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public CustomerCertificate withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public CustomerCertificate withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    public CustomerCertificate withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public CustomerCertificate withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    @Override
    public String expirationDate() {
        return this.expirationDate;
    }

    @Override
    public String subject() {
        return this.subject;
    }

    @Override
    public CustomerCertificate withType(SecretType type) {
        super.withType(type);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.secretSource() != null) {
            this.secretSource().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeJsonField("secretSource", this.secretSource);
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        jsonWriter.writeBooleanField("useLatestVersion", this.useLatestVersion);
        jsonWriter.writeArrayField("subjectAlternativeNames", this.subjectAlternativeNames, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomerCertificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomerCertificate deserializedCustomerCertificate = new CustomerCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedCustomerCertificate.withType(SecretType.fromString(reader.getString()));
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedCustomerCertificate.subject = reader.getString();
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedCustomerCertificate.expirationDate = reader.getString();
                    continue;
                }
                if ("secretSource".equals(fieldName)) {
                    deserializedCustomerCertificate.secretSource = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedCustomerCertificate.secretVersion = reader.getString();
                    continue;
                }
                if ("certificateAuthority".equals(fieldName)) {
                    deserializedCustomerCertificate.certificateAuthority = reader.getString();
                    continue;
                }
                if ("useLatestVersion".equals(fieldName)) {
                    deserializedCustomerCertificate.useLatestVersion = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("subjectAlternativeNames".equals(fieldName)) {
                    List<String> subjectAlternativeNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomerCertificate.subjectAlternativeNames = subjectAlternativeNames;
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCustomerCertificate.thumbprint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomerCertificate;
        });
    }
}

