/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.MatchVariable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.RequestMethodMatchConditionParameters;
import java.io.IOException;

public final class DeliveryRuleRequestMethodCondition
extends DeliveryRuleCondition {
    private MatchVariable name = MatchVariable.REQUEST_METHOD;
    private RequestMethodMatchConditionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleRequestMethodCondition.class);

    @Override
    public MatchVariable name() {
        return this.name;
    }

    public RequestMethodMatchConditionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleRequestMethodCondition withParameters(RequestMethodMatchConditionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property parameters in model DeliveryRuleRequestMethodCondition"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleRequestMethodCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeliveryRuleRequestMethodCondition deserializedDeliveryRuleRequestMethodCondition = new DeliveryRuleRequestMethodCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleRequestMethodCondition.parameters = RequestMethodMatchConditionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleRequestMethodCondition.name = MatchVariable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleRequestMethodCondition;
        });
    }
}

