/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.DimensionProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.MetricAvailability;
import java.io.IOException;
import java.util.List;

public final class MetricSpecification
implements JsonSerializable<MetricSpecification> {
    private String name;
    private String displayName;
    private String displayDescription;
    private String unit;
    private String aggregationType;
    private List<MetricAvailability> availabilities;
    private List<String> supportedTimeGrainTypes;
    private List<DimensionProperties> dimensions;
    private Boolean fillGapWithZero;
    private String metricFilterPattern;
    private Boolean isInternal;

    public String name() {
        return this.name;
    }

    public MetricSpecification withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MetricSpecification withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String displayDescription() {
        return this.displayDescription;
    }

    public MetricSpecification withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public MetricSpecification withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String aggregationType() {
        return this.aggregationType;
    }

    public MetricSpecification withAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public List<MetricAvailability> availabilities() {
        return this.availabilities;
    }

    public MetricSpecification withAvailabilities(List<MetricAvailability> availabilities) {
        this.availabilities = availabilities;
        return this;
    }

    public List<String> supportedTimeGrainTypes() {
        return this.supportedTimeGrainTypes;
    }

    public MetricSpecification withSupportedTimeGrainTypes(List<String> supportedTimeGrainTypes) {
        this.supportedTimeGrainTypes = supportedTimeGrainTypes;
        return this;
    }

    public List<DimensionProperties> dimensions() {
        return this.dimensions;
    }

    public MetricSpecification withDimensions(List<DimensionProperties> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Boolean fillGapWithZero() {
        return this.fillGapWithZero;
    }

    public MetricSpecification withFillGapWithZero(Boolean fillGapWithZero) {
        this.fillGapWithZero = fillGapWithZero;
        return this;
    }

    public String metricFilterPattern() {
        return this.metricFilterPattern;
    }

    public MetricSpecification withMetricFilterPattern(String metricFilterPattern) {
        this.metricFilterPattern = metricFilterPattern;
        return this;
    }

    public Boolean isInternal() {
        return this.isInternal;
    }

    public MetricSpecification withIsInternal(Boolean isInternal) {
        this.isInternal = isInternal;
        return this;
    }

    public void validate() {
        if (this.availabilities() != null) {
            this.availabilities().forEach(e -> e.validate());
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeArrayField("availabilities", this.availabilities, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("supportedTimeGrainTypes", this.supportedTimeGrainTypes, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("fillGapWithZero", this.fillGapWithZero);
        jsonWriter.writeStringField("metricFilterPattern", this.metricFilterPattern);
        jsonWriter.writeBooleanField("isInternal", this.isInternal);
        return jsonWriter.writeEndObject();
    }

    public static MetricSpecification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricSpecification deserializedMetricSpecification = new MetricSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricSpecification.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMetricSpecification.displayName = reader.getString();
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedMetricSpecification.displayDescription = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricSpecification.unit = reader.getString();
                    continue;
                }
                if ("aggregationType".equals(fieldName)) {
                    deserializedMetricSpecification.aggregationType = reader.getString();
                    continue;
                }
                if ("availabilities".equals(fieldName)) {
                    List<MetricAvailability> availabilities = reader.readArray(reader1 -> MetricAvailability.fromJson(reader1));
                    deserializedMetricSpecification.availabilities = availabilities;
                    continue;
                }
                if ("supportedTimeGrainTypes".equals(fieldName)) {
                    List<String> supportedTimeGrainTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedMetricSpecification.supportedTimeGrainTypes = supportedTimeGrainTypes;
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List<DimensionProperties> dimensions = reader.readArray(reader1 -> DimensionProperties.fromJson(reader1));
                    deserializedMetricSpecification.dimensions = dimensions;
                    continue;
                }
                if ("fillGapWithZero".equals(fieldName)) {
                    deserializedMetricSpecification.fillGapWithZero = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("metricFilterPattern".equals(fieldName)) {
                    deserializedMetricSpecification.metricFilterPattern = reader.getString();
                    continue;
                }
                if ("isInternal".equals(fieldName)) {
                    deserializedMetricSpecification.isInternal = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricSpecification;
        });
    }
}

