/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.DeliveryRuleActionValue;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.UrlSigningActionParameters;
import java.io.IOException;

public final class UrlSigningAction
extends DeliveryRuleAction {
    private DeliveryRuleActionValue name = DeliveryRuleActionValue.URL_SIGNING;
    private UrlSigningActionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(UrlSigningAction.class);

    @Override
    public DeliveryRuleActionValue name() {
        return this.name;
    }

    public UrlSigningActionParameters parameters() {
        return this.parameters;
    }

    public UrlSigningAction withParameters(UrlSigningActionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property parameters in model UrlSigningAction"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static UrlSigningAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UrlSigningAction deserializedUrlSigningAction = new UrlSigningAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedUrlSigningAction.parameters = UrlSigningActionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUrlSigningAction.name = DeliveryRuleActionValue.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUrlSigningAction;
        });
    }
}

