/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.ResourceReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.cdn.models.SecretType;
import java.io.IOException;

public final class ValidateSecretInput
implements JsonSerializable<ValidateSecretInput> {
    private SecretType secretType;
    private ResourceReference secretSource;
    private String secretVersion;
    private static final ClientLogger LOGGER = new ClientLogger(ValidateSecretInput.class);

    public SecretType secretType() {
        return this.secretType;
    }

    public ValidateSecretInput withSecretType(SecretType secretType) {
        this.secretType = secretType;
        return this;
    }

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public ValidateSecretInput withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public ValidateSecretInput withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public void validate() {
        if (this.secretType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property secretType in model ValidateSecretInput"));
        }
        if (this.secretSource() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property secretSource in model ValidateSecretInput"));
        }
        this.secretSource().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretType", this.secretType == null ? null : this.secretType.toString());
        jsonWriter.writeJsonField("secretSource", this.secretSource);
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        return jsonWriter.writeEndObject();
    }

    public static ValidateSecretInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidateSecretInput deserializedValidateSecretInput = new ValidateSecretInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("secretType".equals(fieldName)) {
                    deserializedValidateSecretInput.secretType = SecretType.fromString(reader.getString());
                    continue;
                }
                if ("secretSource".equals(fieldName)) {
                    deserializedValidateSecretInput.secretSource = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedValidateSecretInput.secretVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateSecretInput;
        });
    }
}

